/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PolygonTools.java

package ncsa.vecmath;

import java.io.PrintStream;
import java.util.Arrays;
import javax.vecmath.*;

// Referenced classes of package ncsa.vecmath:
//            PointInfo, PointInfoComparator, PointInfoIndexComparator

public class PolygonTools
{

    public PolygonTools()
    {
    }

    public static double area(Point3d apoint3d[])
    {
        double d = 0.0D;
        for(int i = 0; i < apoint3d.length - 1; i++)
        {
            d += ((Tuple3d) (apoint3d[i])).x * ((Tuple3d) (apoint3d[i + 1])).y;
            d -= ((Tuple3d) (apoint3d[i + 1])).x * ((Tuple3d) (apoint3d[i])).y;
        }

        return d / 2D;
    }

    public static double area(Point3d apoint3d[], Vector3d vector3d)
    {
        Vector3d vector3d1 = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        for(int i = 0; i < apoint3d.length - 1; i++)
        {
            vector3d3.set(apoint3d[i]);
            vector3d4.set(apoint3d[i + 1]);
            vector3d1.cross(vector3d3, vector3d4);
            vector3d2.add(vector3d1);
        }

        return vector3d2.dot(vector3d) / 2D;
    }

    public static double area(Point3d apoint3d[], Vector3f vector3f)
    {
        Vector3d vector3d = new Vector3d(((Tuple3f) (vector3f)).x, ((Tuple3f) (vector3f)).y, ((Tuple3f) (vector3f)).z);
        return area(apoint3d, vector3d);
    }

    public static Vector3f[] calculateIndexedNormals(Point3d apoint3d[], int ai[], float f, int i)
    {
        Vector3f avector3f[] = calculateIndexedSurfaceNormals(apoint3d, ai, i);
        int j = avector3f.length;
        PointInfo apointinfo[] = new PointInfo[j];
        PointInfoComparator pointinfocomparator = new PointInfoComparator();
        for(int k = 0; k < j; k++)
            apointinfo[k] = new PointInfo(k, apoint3d[ai[k]], avector3f[k]);

        Arrays.sort(apointinfo, pointinfocomparator);
        PointInfo pointinfo = apointinfo[0];
        int l = 1;
        int i1 = 0;
        int j1 = 0;
        Vector3f vector3f = pointinfo.getSurfaceNormal();
        boolean flag = false;
        for(int k1 = 1; k1 < j; k1++)
        {
            PointInfo pointinfo1 = apointinfo[k1];
            int i2 = pointinfocomparator.compare(pointinfo, pointinfo1);
            if(i2 == 0)
            {
                vector3f.add(vector3f, pointinfo1.getSurfaceNormal());
                l++;
                j1 = k1;
                flag = true;
            } else
            {
                vector3f.scale(1.0F / (float)l);
                for(int k2 = i1; k2 <= j1; k2++)
                    apointinfo[k2].setPointNormal(vector3f);

                i1 = j1 + 1;
                pointinfo = pointinfo1;
                l = 1;
                vector3f = pointinfo.getSurfaceNormal();
                flag = false;
            }
        }

        if(flag)
        {
            vector3f.scale(1.0F / (float)l);
            for(int l1 = i1; l1 < j; l1++)
                apointinfo[l1].setPointNormal(vector3f);

        }
        Arrays.sort(apointinfo, new PointInfoIndexComparator());
        Vector3f avector3f1[] = new Vector3f[j];
        for(int j2 = 0; j2 < j; j2++)
            avector3f1[j2] = apointinfo[j2].getPointNormal();

        return avector3f1;
    }

    public static Vector3f[] calculateIndexedSurfaceNormals(Point3d apoint3d[], int ai[], int i)
    {
        Vector3f avector3f[] = new Vector3f[apoint3d.length];
        boolean flag = false;
        int j = ai.length;
        int k = i - 2;
        for(int l = 0; l < j; l += i)
        {
            int i1 = l;
            Point3d point3d = apoint3d[ai[l]];
            Point3d point3d1 = apoint3d[ai[l + 1]];
            Point3d point3d2 = apoint3d[ai[l + 2]];
            Vector3f vector3f = normal(point3d, point3d1, point3d2);
            for(int j1 = i1; j1 < i1 + i; j1++)
                avector3f[ai[j1]] = new Vector3f(vector3f);

        }

        return avector3f;
    }

    public static Vector3f[] calculateSurfaceNormals(Point3d apoint3d[])
    {
        Vector3f avector3f[] = new Vector3f[100];
        int i = 0;
        for(int j = 0; j < apoint3d.length; j++)
        {
            if(avector3f.length - i < 3)
            {
                Vector3f avector3f1[] = new Vector3f[avector3f.length + 100];
                System.arraycopy(avector3f, 0, avector3f1, 0, avector3f.length);
                avector3f = avector3f1;
            }
            Point3d point3d = apoint3d[j++];
            Point3d point3d1 = apoint3d[j++];
            Point3d point3d2 = apoint3d[j++];
            avector3f[i++] = normal(point3d, point3d1, point3d2);
            avector3f[i++] = normal(point3d, point3d1, point3d2);
            avector3f[i++] = normal(point3d, point3d1, point3d2);
        }

        Vector3f avector3f2[] = new Vector3f[i];
        System.arraycopy(avector3f, 0, avector3f2, 0, i);
        avector3f = avector3f2;
        return avector3f;
    }

    public static Vector3f[] calculateSurfaceNormals(Point3f apoint3f[], int i)
    {
        Vector3f avector3f[] = new Vector3f[100];
        int j = 0;
        for(int k = 0; k < i;)
        {
            if(avector3f.length - j < 3)
            {
                Vector3f avector3f1[] = new Vector3f[avector3f.length + 100];
                System.arraycopy(avector3f, 0, avector3f1, 0, avector3f.length);
                avector3f = avector3f1;
            }
            Point3f point3f = apoint3f[k++];
            Point3f point3f1 = apoint3f[k++];
            Point3f point3f2 = apoint3f[k++];
            avector3f[j++] = normal(point3f, point3f1, point3f2);
            avector3f[j++] = normal(point3f, point3f1, point3f2);
            avector3f[j++] = normal(point3f, point3f1, point3f2);
        }

        Vector3f avector3f2[] = new Vector3f[j];
        System.arraycopy(avector3f, 0, avector3f2, 0, j);
        avector3f = avector3f2;
        return avector3f;
    }

    public static void dump(Point3d apoint3d[])
    {
        System.out.println("****START POLYGON VERTEX LIST****" + apoint3d);
        for(int i = 0; i < apoint3d.length; i++)
            System.out.println(apoint3d[i]);

        System.out.println("****END POLYGON VERTEX LIST****" + apoint3d);
    }

    public static Vector3f normal(Point3d point3d, Point3d point3d1, Point3d point3d2)
    {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        vector3f.set(point3d);
        vector3f1.set(point3d1);
        vector3f2.set(point3d2);
        vector3f4.sub(vector3f, vector3f1);
        vector3f5.sub(vector3f1, vector3f2);
        vector3f3.cross(vector3f4, vector3f5);
        return vector3f3;
    }

    public static Vector3f normal(Point3f point3f, Point3f point3f1, Point3f point3f2)
    {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        vector3f.set(point3f);
        vector3f1.set(point3f1);
        vector3f2.set(point3f2);
        vector3f4.sub(vector3f, vector3f1);
        vector3f5.sub(vector3f1, vector3f2);
        vector3f3.cross(vector3f4, vector3f5);
        return vector3f3;
    }

    public static Vector3f normal(Point3d apoint3d[])
    {
        return normal(apoint3d[0], apoint3d[1], apoint3d[2]);
    }

    public static Vector3f normal(Point3f apoint3f[])
    {
        return normal(apoint3f[0], apoint3f[1], apoint3f[2]);
    }

    public static Vector3f[] pointNormals(Point3d apoint3d[], int i, Vector3f avector3f[], float f)
    {
        int j = i;
        PointInfo apointinfo[] = new PointInfo[j];
        PointInfoComparator pointinfocomparator = new PointInfoComparator();
        for(int k = 0; k < j; k++)
            apointinfo[k] = new PointInfo(k, apoint3d[k], avector3f[k]);

        Arrays.sort(apointinfo, pointinfocomparator);
        PointInfo pointinfo = apointinfo[0];
        int l = 1;
        int i1 = 0;
        int j1 = 0;
        Vector3f vector3f = pointinfo.getSurfaceNormal();
        boolean flag = false;
        for(int k1 = 1; k1 < j; k1++)
        {
            PointInfo pointinfo1 = apointinfo[k1];
            int i2 = pointinfocomparator.compare(pointinfo, pointinfo1);
            if(i2 == 0)
            {
                vector3f.add(vector3f, pointinfo1.getSurfaceNormal());
                l++;
                j1 = k1;
                flag = true;
            } else
            {
                vector3f.scale(1.0F / (float)l);
                for(int k2 = i1; k2 <= j1; k2++)
                    apointinfo[k2].setPointNormal(vector3f);

                i1 = j1 + 1;
                pointinfo = pointinfo1;
                l = 1;
                vector3f = pointinfo.getSurfaceNormal();
                flag = false;
            }
        }

        if(flag)
        {
            vector3f.scale(1.0F / (float)l);
            for(int l1 = i1; l1 < j; l1++)
                apointinfo[l1].setPointNormal(vector3f);

        }
        Arrays.sort(apointinfo, new PointInfoIndexComparator());
        Vector3f avector3f1[] = new Vector3f[j];
        for(int j2 = 0; j2 < j; j2++)
            avector3f1[j2] = apointinfo[j2].getPointNormal();

        return avector3f1;
    }

    public static void reverseWinding(Point3d apoint3d[])
    {
        for(int i = 1; i < Math.round((float)apoint3d.length / 2.0F); i++)
        {
            Point3d point3d = apoint3d[apoint3d.length - i];
            apoint3d[apoint3d.length - i] = apoint3d[i];
            apoint3d[i] = point3d;
        }

    }
}
