/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   TriangleDeconstructor.java

package ncsa.vecmath;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.*;

public class TriangleDeconstructor
{

    public TriangleDeconstructor()
    {
    }

    public static Point3d[][] destruct(Point3d apoint3d[])
    {
        if(apoint3d.length <= 3)
        {
            Point3d apoint3d1[][] = new Point3d[1][apoint3d.length];
            for(int i = 0; i < apoint3d.length; i++)
                apoint3d1[0][i] = apoint3d[i];

            return apoint3d1;
        } else
        {
            Matrix4d matrix4d = figureTranslation(apoint3d);
            multiply(matrix4d, apoint3d);
            Vector3d vector3d = figureXVector(apoint3d);
            Vector3d vector3d1 = figureYVector(vector3d);
            Vector3d vector3d2 = figureZVector(vector3d, vector3d1);
            Matrix4d matrix4d1 = figureRotation(vector3d, vector3d1, vector3d2);
            multiply(matrix4d1, apoint3d);
            Point3d apoint3d2[][] = makeConvexPolygons(apoint3d);
            Point3d apoint3d3[][] = makeTriangles(apoint3d2);
            matrix4d1.invert();
            multiply(matrix4d1, apoint3d);
            matrix4d.invert();
            multiply(matrix4d, apoint3d);
            return apoint3d3;
        }
    }

    static void dump(Point3d apoint3d[])
    {
        for(int i = 0; i < apoint3d.length; i++)
            System.out.println(apoint3d[i]);

        System.out.println("**************************");
    }

    static Matrix4d figureRotation(Vector3d vector3d, Vector3d vector3d1, Vector3d vector3d2)
    {
        Matrix4d matrix4d = new Matrix4d(((Tuple3d) (vector3d)).x, ((Tuple3d) (vector3d)).y, ((Tuple3d) (vector3d)).z, 0.0D, ((Tuple3d) (vector3d1)).x, ((Tuple3d) (vector3d1)).y, ((Tuple3d) (vector3d1)).z, 0.0D, ((Tuple3d) (vector3d2)).x, ((Tuple3d) (vector3d2)).y, ((Tuple3d) (vector3d2)).z, 0.0D, 0.0D, 0.0D, 0.0D, 1.0D);
        if(DEBUG_ROTATION)
            System.out.println(matrix4d);
        return matrix4d;
    }

    static Matrix4d figureTranslation(Point3d apoint3d[])
    {
        Matrix4d matrix4d = new Matrix4d();
        Vector3d vector3d = new Vector3d(-((Tuple3d) (apoint3d[0])).x, -((Tuple3d) (apoint3d[0])).y, -((Tuple3d) (apoint3d[0])).z);
        matrix4d.set(vector3d);
        return matrix4d;
    }

    static Vector3d figureXVector(Point3d apoint3d[])
    {
        Vector3d vector3d = new Vector3d(((Tuple3d) (apoint3d[1])).x, ((Tuple3d) (apoint3d[1])).y, ((Tuple3d) (apoint3d[1])).z);
        vector3d.normalize();
        if(DEBUG_ROTATION)
            System.out.println("figureXVector " + vector3d);
        return vector3d;
    }

    static Vector3d figureYVector(Vector3d vector3d)
    {
        Vector3d vector3d1 = new Vector3d();
        Vector3d vector3d2 = new Vector3d(1.0D, 0.0D, 0.0D);
        vector3d1.cross(vector3d2, vector3d);
        vector3d1.normalize();
        if(DEBUG_ROTATION)
            System.out.println("figureYVector " + vector3d1);
        return vector3d1;
    }

    static Vector3d figureYVector(Vector3d vector3d, Vector3d vector3d1)
    {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.cross(vector3d, vector3d1);
        vector3d2.normalize();
        if(DEBUG_ROTATION)
            System.out.println("figureYVector " + vector3d2);
        return vector3d2;
    }

    static Vector3d figureZVector(Vector3d vector3d, Vector3d vector3d1)
    {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.cross(vector3d, vector3d1);
        vector3d2.normalize();
        if(DEBUG_ROTATION)
            System.out.println("figureZVector " + vector3d2);
        return vector3d2;
    }

    static Vector3d figureZVector(Point3d apoint3d[])
    {
        if(DEBUG_FIGUREZVECTOR)
            System.out.println("######figureZVector###################");
        Vector3d vector3d = new Vector3d(((Tuple3d) (apoint3d[1])).x, ((Tuple3d) (apoint3d[1])).y, ((Tuple3d) (apoint3d[1])).z);
        Vector3d vector3d1 = new Vector3d(((Tuple3d) (apoint3d[2])).x, ((Tuple3d) (apoint3d[2])).y, ((Tuple3d) (apoint3d[2])).z);
        Vector3d vector3d2 = new Vector3d(((Tuple3d) (apoint3d[3])).x, ((Tuple3d) (apoint3d[3])).y, ((Tuple3d) (apoint3d[3])).z);
        if(DEBUG_FIGUREZVECTOR)
        {
            System.out.println("p1 " + vector3d);
            System.out.println("p2 " + vector3d1);
            System.out.println("p3 " + vector3d2);
        }
        vector3d1.sub(vector3d);
        vector3d2.sub(vector3d);
        if(DEBUG_FIGUREZVECTOR)
        {
            System.out.println("p2-p1 " + vector3d1);
            System.out.println("p3-p1 " + vector3d2);
        }
        vector3d.cross(vector3d1, vector3d2);
        if(DEBUG_FIGUREZVECTOR)
            System.out.println("p2Xp3 " + vector3d);
        vector3d.normalize();
        if(DEBUG_FIGUREZVECTOR)
        {
            System.out.println("normalized " + vector3d);
            System.out.println("#############################");
        }
        if(DEBUG_ROTATION)
            System.out.println("figureZVector " + vector3d);
        return vector3d;
    }

    public static void main(String args[])
    {
        if(!parseArgs(args))
            return;
        Point3d apoint3d[][] = makeTests();
        for(int i = 0; i < apoint3d.length; i++)
        {
            for(int j = 0; j < apoint3d[i].length; j++)
                System.out.print(String.valueOf(apoint3d[i][j]) + " ");

            System.out.println("");
            System.out.println("***************");
            Point3d apoint3d1[][] = destruct(apoint3d[i]);
            for(int k = 0; k < apoint3d1.length; k++)
            {
                for(int l = 0; l < apoint3d1[k].length; l++)
                    System.out.print(String.valueOf(apoint3d1[k][l]) + " ");

                System.out.println(" ");
            }

            System.out.println("---------------");
        }

    }

    static Point3d[][] makeConvexPolygons(Point3d apoint3d[])
    {
        Point3d apoint3d1[][] = new Point3d[1][apoint3d.length];
        for(int i = 0; i < apoint3d.length; i++)
            apoint3d1[0][i] = apoint3d[i];

        return apoint3d1;
    }

    static Point3d[][] makeTests()
    {
        Point3d apoint3d[][] = new Point3d[1][];
        apoint3d[0] = new Point3d[4];
        apoint3d[0][0] = new Point3d(1.0D, 1.0D, 0.0D);
        apoint3d[0][1] = new Point3d(0.0D, 2D, 0.0D);
        apoint3d[0][2] = new Point3d(2D, 2D, 0.0D);
        apoint3d[0][3] = new Point3d(2D, 0.0D, 0.0D);
        return apoint3d;
    }

    static Point3d[][] makeTriangles(Point3d apoint3d[][])
    {
        Vector vector = new Vector();
        for(int i = 0; i < apoint3d.length; i++)
        {
            for(int j = 1; j + 1 < apoint3d[i].length; j++)
            {
                Point3d apoint3d2[] = new Point3d[3];
                apoint3d2[0] = apoint3d[i][0];
                apoint3d2[1] = apoint3d[i][j];
                apoint3d2[2] = apoint3d[i][j + 1];
                vector.addElement(apoint3d2);
            }

        }

        if(DEBUG_MAKETRIANGLES)
            System.out.println("We have " + vector.size() + " triangles in the vector");
        Point3d apoint3d1[][] = new Point3d[vector.size()][];
        int k = 0;
        for(Enumeration enumeration = vector.elements(); enumeration.hasMoreElements();)
            apoint3d1[k++] = (Point3d[])enumeration.nextElement();

        return apoint3d1;
    }

    static void multiply(Matrix4d matrix4d, Point3d apoint3d[])
    {
        for(int i = 0; i < apoint3d.length; i++)
            matrix4d.transform(apoint3d[i]);

    }

    static void multiply(Matrix4d matrix4d, Point3d apoint3d[][])
    {
        for(int i = 0; i < apoint3d.length; i++)
        {
            for(int j = 0; j < apoint3d[i].length; j++)
                matrix4d.transform(apoint3d[i][j]);

        }

    }

    static boolean parseArgs(String as[])
    {
        if(as.length == 0)
            return true;
        if(as[0].compareTo("help") == 0)
        {
            System.out.println("rotation to see the rotation vectors");
            System.out.println("triangles to see how many triangle are made");
            return false;
        }
        for(int i = 0; i < as.length; i++)
        {
            if(as[i].compareTo("rotation") == 0)
                DEBUG_ROTATION = true;
            if(as[i].compareTo("vectors") == 0)
                DEBUG_FIGUREZVECTOR = true;
            if(as[i].compareTo("triangles") == 0)
                DEBUG_MAKETRIANGLES = true;
        }

        return true;
    }

    static void reverseWinding(Point3d apoint3d[])
    {
        for(int i = 1; i < Math.round((float)apoint3d.length / 2.0F); i++)
        {
            Point3d point3d = apoint3d[apoint3d.length - i];
            apoint3d[apoint3d.length - i] = apoint3d[i];
            apoint3d[i] = point3d;
        }

    }

    static float signedArea(Point3d apoint3d[])
    {
        float f = 0.0F;
        float f1 = 0.0F;
        for(int i = 0; i < apoint3d.length - 1; i++)
        {
            f = (float)((double)f + ((Tuple3d) (apoint3d[i])).x * ((Tuple3d) (apoint3d[i + 1])).y);
            f1 = (float)((double)f1 - ((Tuple3d) (apoint3d[i + 1])).x * ((Tuple3d) (apoint3d[i])).y);
        }

        return (f + f1) / 2.0F;
    }

    static boolean DEBUG_ROTATION = false;
    static boolean DEBUG_FIGUREZVECTOR = false;
    static boolean DEBUG_MAKETRIANGLES = false;

}
