 package sim.app.antsforage;

import sim.engine.*;
import sim.field.grid.*;
import ec.util.*;

public /*strictfp*/ class AntsForage extends SimState
    {

    public static final int HOME_XMIN = 75;
    public static final int HOME_XMAX = 75;
    public static final int HOME_YMIN = 75;
    public static final int HOME_YMAX = 75;

    public static final int FOOD_XMIN = 25;
    public static final int FOOD_XMAX = 25;
    public static final int FOOD_YMIN = 25;
    public static final int FOOD_YMAX = 25;

    public static final int MAX_ANTS_PER_LOCATION = 10;
    public static final int TIME_TO_LIVE = 1000;
    public static final int NEW_ANTS_PER_TIME_STEP = 2;
    public static final int MAX_ANTS = 1000;
    public static final int INITIALANTS = 2;
    public static final double MIN_PHEROMONE = 0.0;
    public static final double MAX_PHEROMONE = 1000.0;
    public static final double PHEROMONE_TO_LEAVE_BEHIND = 1;

    public static final double EVAPORATE_CONSTANT = 0.0001;
    public static final double DIFFUSION_CONSTANT = 0.0001;
    public static final int GRID_HEIGHT = 100;
    public static final int GRID_WIDTH = 100;

    public static final int NO_OBSTACLES = 0;
    public static final int ONE_OBSTACLE = 1;
    public static final int TWO_OBSTACLES = 2;
    public static final int ONE_LONG_OBSTACLE = 3;

    public static final int OBSTACLES = TWO_OBSTACLES;

/*
    public static final int HOME_XMIN = 24;
    public static final int HOME_XMAX = 26;
    public static final int HOME_YMIN = 24;
    public static final int HOME_YMAX = 26;

    public static final int FOOD_XMIN = 4;
    public static final int FOOD_XMAX = 6;
    public static final int FOOD_YMIN = 42;
    public static final int FOOD_YMAX = 44;

    public static final int MAX_ANTS_PER_LOCATION = 5;
    public static final int TIME_TO_LIVE = 200;
    public static final int NEW_ANTS_PER_TIME_STEP = 2;
    public static final int MAX_ANTS = 100;
    public static final int INITIALANTS = 2;
    public static final double MIN_PHEROMONE = 0.0;
    public static final double MAX_PHEROMONE = 110.0;
    public static final double PHEROMONE_TO_LEAVE_BEHIND = 1;

    public static final double EVAPORATE_CONSTANT = 0.01;
    public static final double DIFFUSION_CONSTANT = 0.05;
    public static final int GRID_HEIGHT = 50;
    public static final int GRID_WIDTH = 50;
    public static final double RANDOM_MOVEMENT_PROBABILITY = 0.1;
*/

/*
    public static final int HOME_XMIN = 52;
    public static final int HOME_XMAX = 54;
    public static final int HOME_YMIN = 52;
    public static final int HOME_YMAX = 54;

    public static final int FOOD_XMIN = 22;
    public static final int FOOD_XMAX = 24;
    public static final int FOOD_YMIN = 22;
    public static final int FOOD_YMAX = 24;

    public static final int MAX_ANTS_PER_LOCATION = 10;
    public static final int TIME_TO_LIVE = 200;
    public static final int newAntsPerTimeStep = 10;
    public static final int MAX_ANTS = 1000;
    public static final int INITIALANTS = 1;
    public static final double MIN_PHEROMONE = 0.0;
    public static final double MAX_PHEROMONE = 10.0;
    public static final double PHEROMONE_TO_LEAVE_BEHIND = 1;

    public static final double EVAPORATE_CONSTANT = 0.001;
    public static final double DIFFUSION_CONSTANT = 0.001;
    public static final int GRID_HEIGHT = 100;
    public static final int GRID_WIDTH = 100;
    public static final double RANDOM_MOVEMENT_PROBABILITY = 0.1;
*/

    public DoubleGrid2D sites = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
    public DoubleGrid2D toFoodGrid = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
    public DoubleGrid2D toHomeGrid = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
    public DoubleGrid2D valgrid2 = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT, 0);
    public SparseGrid2D buggrid = new SparseGrid2D(GRID_WIDTH, GRID_HEIGHT);
    public DoubleGrid2D obstacles = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);

    public AntsForage(long seed)
        { 
        super(new MersenneTwisterFast(seed), new Schedule(2));
        }
        
    public int foodCollected = 0;

    public void start()
        {
        super.start();  // clear out the schedule

        // make new grids
        sites = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
        toFoodGrid = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
        toHomeGrid = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT,0);
        valgrid2 = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT, 0);
        buggrid = new SparseGrid2D(GRID_WIDTH, GRID_HEIGHT);
        obstacles = new DoubleGrid2D(GRID_WIDTH, GRID_HEIGHT, 0);

        foodCollected = 0;

        switch( OBSTACLES )
        {
            case NO_OBSTACLES:
                break;
            case ONE_OBSTACLE:
                for( int x = 0 ; x < GRID_WIDTH ; x++ )
                    for( int y = 0 ; y < GRID_HEIGHT ; y++ )
                    {
                        obstacles.field[x][y] = 0.0;
                        if( ((x-55)*0.707+(y-35)*0.707)*((x-55)*0.707+(y-35)*0.707)/36+
                            ((x-55)*0.707-(y-35)*0.707)*((x-55)*0.707-(y-35)*0.707)/1024 <= 1 )
                            obstacles.field[x][y] = 1.0;
                    }
                break;
            case TWO_OBSTACLES:
                for( int x = 0 ; x < GRID_WIDTH ; x++ )
                    for( int y = 0 ; y < GRID_HEIGHT ; y++ )
                    {
                        obstacles.field[x][y] = 0.0;
                        if( ((x-45)*0.707+(y-25)*0.707)*((x-45)*0.707+(y-25)*0.707)/36+
                            ((x-45)*0.707-(y-25)*0.707)*((x-45)*0.707-(y-25)*0.707)/1024 <= 1 )
                            obstacles.field[x][y] = 1.0;
                        if( ((x-35)*0.707+(y-70)*0.707)*((x-35)*0.707+(y-70)*0.707)/36+
                            ((x-35)*0.707-(y-70)*0.707)*((x-35)*0.707-(y-70)*0.707)/1024 <= 1 )
                            obstacles.field[x][y] = 1.0;
                    }
                break;
            case ONE_LONG_OBSTACLE:
                for( int x = 0 ; x < GRID_WIDTH ; x++ )
                    for( int y = 0 ; y < GRID_HEIGHT ; y++ )
                    {
                        obstacles.field[x][y] = 0.0;
                        if( (x-60)*(x-60)/1600+
                            (y-50)*(y-50)/25 <= 1 )
                            obstacles.field[x][y] = 1.0;
                    }
                break;
            }

        // initialize the grid with the home and food sites
        for( int x = HOME_XMIN ; x <= HOME_XMAX ; x++ )
            for( int y = HOME_YMIN ; y <= HOME_YMAX ; y++ )
                sites.field[x][y] = 1.0;
        for( int x = FOOD_XMIN ; x <= FOOD_XMAX ; x++ )
            for( int y = FOOD_YMIN ; y <= FOOD_YMAX ; y++ )
                sites.field[x][y] = 0.5;

        // make the decreaser 
        Steppable decreaser = new Steppable()
            {
            public void step(SimState state)
                {
                //
                // evaporate 'n diffuse the pheromones pointing to food
                //
                // for each x and y position
                for(int x=0;x<GRID_WIDTH;x++)
                    for(int y=0;y<GRID_HEIGHT;y++)
                        {
                        double average = 0.0;
                        // for each neighbor of that position
                        for(int dx=-1; dx< 2; dx++)
                            for(int dy=-1; dy<2; dy++)
                                {
                                // compute the toroidal <x,y> position of the neighbor
                                int xx = (x+ dx + GRID_WIDTH) % GRID_WIDTH;
                                int yy = (y+ dy + GRID_HEIGHT) % GRID_HEIGHT;
                                
                                // compute average
                                average += AntsForage.this.toFoodGrid.field[xx][yy];
                                }
                        average /= 9;

                        // dissipation & evaporation
                        AntsForage.this.valgrid2.field[x][y] = /*Strict*/Math.min( /*Strict*/Math.max( (1.0-EVAPORATE_CONSTANT) *
                                                                                   AntsForage.this.toFoodGrid.field[x][y] +
                                                                                   DIFFUSION_CONSTANT *
                                                                                   (average-AntsForage.this.toFoodGrid.field[x][y]),
                                                                                   AntsForage.MIN_PHEROMONE ),
                                                                         AntsForage.MAX_PHEROMONE);
                        }
                for(int x=0;x<GRID_WIDTH;x++)
                    for(int y=0;y<GRID_HEIGHT;y++)
                        AntsForage.this.toFoodGrid.field[x][y] = AntsForage.this.valgrid2.field[x][y];
//                AntsForage.this.toFoodGrid.setTo(AntsForage.this.valgrid2);

                //
                // evaporate 'n diffuse the pheromones pointing to home
                //
                // for each x and y position
                for(int x=0;x<GRID_WIDTH;x++)
                    for(int y=0;y<GRID_HEIGHT;y++)
                        {
                        double average = 0.0;
                        // for each neighbor of that position
                        for(int dx=-1; dx< 2; dx++)
                            for(int dy=-1; dy<2; dy++)
                                {
                                // compute the toroidal <x,y> position of the neighbor
                                int xx = (x+ dx + GRID_WIDTH) % GRID_WIDTH;
                                int yy = (y+ dy + GRID_HEIGHT) % GRID_HEIGHT;
                                
                                // compute average
                                average += AntsForage.this.toHomeGrid.field[xx][yy];
                                }
                        average /= 9;

                        // dissipation & evaporation
                        AntsForage.this.valgrid2.field[x][y] = /*Strict*/Math.min( /*Strict*/Math.max( (1.0-EVAPORATE_CONSTANT) *
                                                                                   AntsForage.this.toHomeGrid.field[x][y] +
                                                                                   DIFFUSION_CONSTANT *
                                                                                   (average-AntsForage.this.toHomeGrid.field[x][y]),
                                                                                   AntsForage.MIN_PHEROMONE ),
                                                                         AntsForage.MAX_PHEROMONE);
                        }
                for(int x=0;x<GRID_WIDTH;x++)
                    for(int y=0;y<GRID_HEIGHT;y++)
                        AntsForage.this.toHomeGrid.field[x][y] = AntsForage.this.valgrid2.field[x][y];
//                AntsForage.this.toHomeGrid.setTo(AntsForage.this.valgrid2);
                }
            };

        // make the ant farm 
        Steppable antFarm = new Steppable()
        {
            public void step(SimState state)
            {
                for(int x=0 ; x<NEW_ANTS_PER_TIME_STEP && numberOfAnts<MAX_ANTS ; x++)
                {
                    Ant bug = new Ant( random.nextInt(8),
                                       PHEROMONE_TO_LEAVE_BEHIND,
                                       MIN_PHEROMONE,
                                       MAX_PHEROMONE,
                                       TIME_TO_LIVE ); 
                    buggrid.setObjectLocation(bug,(HOME_XMAX+HOME_XMIN)/2,(HOME_YMAX+HOME_YMIN)/2);
                    bug.toDiePointer = schedule.scheduleRepeating(bug);
                    numberOfAnts++;
                }
            }
        };

        numberOfAnts = 0;

        // Schedule the heat bugs -- we could instead use a RandomSequence, which would be faster,
        // but this is a good test of the scheduler
        for(int x=0;x<INITIALANTS;x++)
            {
            Ant bug = new Ant(random.nextInt(8),
                              PHEROMONE_TO_LEAVE_BEHIND,
                              MIN_PHEROMONE,
                              MAX_PHEROMONE,
                              TIME_TO_LIVE ); 
            buggrid.setObjectLocation(bug,(HOME_XMAX+HOME_XMIN)/2,(HOME_YMAX+HOME_YMIN)/2);
            bug.toDiePointer = schedule.scheduleRepeating(bug);
            numberOfAnts++;
            }
                            
        // Schedule the decreaser to happen after the AntsForage
        schedule.scheduleRepeating(Schedule.EPOCH,1,decreaser,1);
        // Schedule the ant farm to happen after the AntsForage
        schedule.scheduleRepeating(Schedule.EPOCH,1,antFarm,1);
        }

    public static int numberOfAnts = 0;
















    /** Runs AntsForage headless (no GUI).  Checkpoints out to files every 500 simulation timesteps.
        If no command-line arguments are provided, a new AntsForage is started.
        Optionally the user can say "-checkpoint [filename]" and AntsForage will load a checkpoint
        and continue from that point. */
        
    // This example is overly elaborate, with checkpointing and stuff.
    // But to run a simulation, the basic thing you need to do is:
    //
    //
    // 1. Make a SimState		antsforage = new AntsForage(23);  // seed the RNG with 23, what the heck
    // 2. Tell it we're starting	antsforage.start();
    // 3. Loop:				for(...however long I want to run...)
    // 4. 	Step the schedule		if (!antsforage.schedule.step(antsforage)) break;
    // 5. Finish up			antsforage.finish();
    //
    // ...and that's it!
    
    public static void main(String[] args)
        {
        AntsForage antsforage = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new java.io.File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof AntsForage))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state.getClass().getName());
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    antsforage = (AntsForage)state;
                }
        
        // ...or should we start fresh?
        if (antsforage==null)  // no checkpoint file requested
            {
            antsforage = new AntsForage(System.currentTimeMillis());  // make a new antsforage.  Seed the RNG with the time
            antsforage.start();  // prep the bugs!
            System.out.println("Starting AntsForage.  Running for 5000 steps.");
            }
        
        long time;
        while((time = antsforage.schedule.time()) < 5000)
            {
            // step the schedule.  This is where everything happens.
            if (!antsforage.schedule.step(antsforage)) break;   // it won't happen that we end prematurely,
                                                            // but it's worth checking for!

            if (time%100==0 && time!=0) 
		System.out.println("Time Step " + time + "    Food Collected " + antsforage.foodCollected);
        
            // checkpoint
            if (time%500==0 && time!=0)
                {
                String s = "ants." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
		antsforage.writeToCheckpoint(new java.io.File(s));
                }
            }
            
        antsforage.finish();  // we don't use this, but it's good style
        }
    }
    
    
    
    
    
