package sim.app.antsforage;

import sim.engine.*;
import sim.display.*;
import sim.portrayal.grid.*;
import java.awt.*;
import javax.swing.*;

public class AntsForageWithUI extends GUIState
    {
    public Display2D display;
    public JFrame displayFrame;

    FastValueGrid2DPortrayal homePheremonePortrayal = new FastValueGrid2DPortrayal("Home Pheremone");
    FastValueGrid2DPortrayal foodPheremonePortrayal = new FastValueGrid2DPortrayal("Food Pheremone");
    FastValueGrid2DPortrayal sitesPortrayal = new FastValueGrid2DPortrayal("Site", true);  // immutable
    FastValueGrid2DPortrayal obstaclesPortrayal = new FastValueGrid2DPortrayal("Obstacle", true);  // immutable
    SparseGrid2DPortrayal bugPortrayal = new SparseGrid2DPortrayal();
                
    public static void main(String[] args)
        {
        AntsForageWithUI antsForage = new AntsForageWithUI();
        Console c = new Console(antsForage);
        c.setVisible(true);
        }
    
    public AntsForageWithUI() { super(new AntsForage(System.currentTimeMillis())); }
    public AntsForageWithUI(SimState state) { super(state); }
    
    public String getName() { return "Ants Forage"; }
    
    public String getInfo()  // we'll just assume it's HTML
        {
        AntsForage af = (AntsForage)state;
        return "<H2>AntsForage</H2>by Liviu Panait.<p>Part of the little simulator we're building.  Let's test the HTML output.  For the heck, the current values are:" +
        "<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
        "<tr><td>Evaporation Constant</td><td>" + AntsForage.EVAPORATE_CONSTANT  + "</td></tr>" +
        "<tr><td>Diffusion Constant</td><td>" + AntsForage.DIFFUSION_CONSTANT  + "</td></tr>" +
        "<tr><td>Grid Height</td><td>" + AntsForage.GRID_HEIGHT  + "</td></tr>" +
        "<tr><td>Grid Width</td><td>" + AntsForage.GRID_WIDTH  + "</td></tr>" +
        "</table>"; }
    
    public void setupPortrayals()
        {
        AntsForage af = (AntsForage)state;

        // tell the portrayals what to portray and how to portray them
        homePheremonePortrayal.setField(af.toHomeGrid);
        homePheremonePortrayal.setLevels(
		AntsForage.MIN_PHEROMONE,AntsForage.MAX_PHEROMONE,new Color(0,255,0,0), new Color(0,255,0,255) );
        foodPheremonePortrayal.setField(af.toFoodGrid);
        foodPheremonePortrayal.setLevels(
		AntsForage.MIN_PHEROMONE,AntsForage.MAX_PHEROMONE,new Color(0,0,255,0), new Color(0,0,255,255) );
        sitesPortrayal.setField(af.sites);
        sitesPortrayal.setLevels(0,1,new Color(0,0,0,0), new Color(255,0,0,255) );
        obstaclesPortrayal.setField(af.obstacles);
        obstaclesPortrayal.setLevels(0,1,new Color(0,0,0,0), new Color(128,64,64,255) );
        bugPortrayal.setField(af.buggrid);
            
        // make the ants look like cameras!
/*        bugPortrayal.setPortrayalForAll(
            new sim.portrayal.simple.ImagePortrayal2D(
                sim.display.Display2D.CAMERA_ICON.getImage()));
*/        
        // reschedule the displayer
        display.reset();

        // redraw the display
        display.repaint();
        }
    
    public void start()
        {
        super.start();  // set up everything but replacing the display
        // set up our portrayals
        setupPortrayals();
        }
            
    public void load(SimState state)
        {
        super.load(state);
        // we now have new grids.  Set up the portrayals to reflect that
        setupPortrayals();
        }

    public void init(Controller c)
        {
        super.init(c);
        
        // Make the Display2D.  We'll have it display stuff later.
        display = new Display2D(400,400,this,1); // at 400x400, we've got 4x4 per array position
        displayFrame = display.createFrame();
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);

        // attach the portrayals from bottom to top
        display.attach(homePheremonePortrayal,"Pheromones To Home");
        display.attach(foodPheremonePortrayal,"Pheromones To Food");
        display.attach(sitesPortrayal,"Site Locations");
        display.attach(obstaclesPortrayal,"Obstacles");
        display.attach(bugPortrayal,"Agents");
        
        // specify the backdrop color  -- what gets painted behind the displays
        display.setBackdrop(Color.white);
        }
        
    public void quit()
        {
        super.quit();
        
        // disposing the displayFrame automatically calls quit() on the display,
        // so we don't need to do so ourselves here.
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;  // let gc
        display = null;       // let gc
        }
        
    }
    
    
    
    
    