package sim.app.antsforage;

import java.awt.*;
import sim.portrayal.grid.*;
import sim.field.grid.*;

/** We define a fun little portrayal here which normalizes the perceived values in the grid
    by dividing them by the maximum value prior to drawing.  This portrayal only works with
    DoubleGrid2D objects. */

public final class NormalizingGrid2DPortrayal extends ValueGrid2DPortrayal
    {
    double max;
        
    // hook in to compute the normalization
    public void draw(Object object, java.awt.Graphics2D graphics, sim.portrayal.DrawInfo2D info)
        {
        max = ((DoubleGrid2D)field).max();
        super.draw(object, graphics,info);
        }
    
    // define the color
    public Color getColor(double level)
        {
        if (max > minLevel)
            return super.getColor(level / (max-minLevel));
        else return super.getColor(level);  // which will get truncated to  minLevel...
        }
    }


