package sim.app.crowd3d;

import sim.display.*;
import sim.display3d.*;
import sim.portrayal3d.*;
import sim.portrayal3d.simple.*;
import sim.portrayal3d.continuous.*;
import java.awt.*;

import javax.swing.*;

public class Crowd3DWithUI extends GUIState
{
                
	public JFrame mDisplayFrame; 
	FieldPortrayal3D boidsP;
	Portrayal3D wireFrameP;

    public static void main(String[] args)
	{
		// we use SyncSchedule because we're drawing on the screen and so will have multiple threads
        Crowd3DWithUI boids = new Crowd3DWithUI(new CrowdSim(System.currentTimeMillis()));

		Console c = new Console(boids);
		c.setVisible(true);        
	}

	public Crowd3DWithUI()
	{
		this(new CrowdSim(System.currentTimeMillis()));	
	}
	public Crowd3DWithUI(CrowdSim b)
	{
		super(b);
		boidsP = new Continuous3DPortrayal(b.boidSpace, 0, 0, 0, b.spaceHeight, b.spaceHeight, b.spaceDepth);
		wireFrameP = new WireFrameBoxPortrayal3D(	b.spaceWidth, 
        											b.spaceHeight, 
        											b.spaceDepth, 
        											1.0/Math.max(b.spaceWidth, Math.max(b.spaceHeight, b.spaceDepth)));
	}
    
    private void setDisplayPreferredSize(){    
		mDisplay.setPreferredSize(new Dimension(600,600));
    }
	public String getName() { return "Spacing Demo"; }
	
	public String getInfo()
    { 
    	CrowdSim b = (CrowdSim)state;
    	return "<H2>Spacing Demonstration</H2>by Gabriel Catalin Balan.<p>Parameters:" +
			"<tr><td>Boids insertion frequency</td><td>1/(" + b.STEPS_BETWEEN_INSERTS  + " steps)</td></tr>" +
			"<tr><td>Crowd aversion factor</td><td>" + Agent.CROWD_AVERSION  + "</td></tr>" +
			"<tr><td>Wall aversion factor</td><td>" + Agent.WALL_AVERSION  + "</td></tr>" +
			"<tr><td>Sight distance</td><td>" + Agent.SIGHT  + "</td></tr>" +
			"<tr><td>Minimum force threshold</td><td>" + Agent.FORCE_MIN_THRESHOLD  + "</td></tr>" +
			"<tr><td>Fish tank size</td><td>" + b.spaceHeight+"x"+b.spaceWidth+"x"+b.spaceDepth + "</td></tr>" +
			"<tr><td>Speed</td><td>" + Agent.SPEED  + "</td></tr>" +
			"</table>";
	}

	public void start()
    {
    	super.start();
		boidsP.setField(((CrowdSim)state).boidSpace);
        mDisplay.reset();
    }
    
	public Display3D mDisplay;

	public void init(Controller c)
	{
		super.init(c);
		mDisplay = new Display3D(500,500,this,1);

        mDisplay.attach(wireFrameP, "Fish tank");
		boidsP.setPortrayalForAll(new GullPortrayal3D());
        mDisplay.attach(boidsP, "boids");
		
		mDisplay.createSceneGraph(false);
		//have the spinner go slower than Display3D's default
		mDisplay.getSpinnterpolator().setAlpha(new javax.media.j3d.Alpha(-1, 50000));
		mDisplay.setSpinBehaviorEnabled(true);
		mDisplay.setOrbitBehaviorEnabled(true);
		
        setDisplayPreferredSize();
		mDisplayFrame = new JFrame();		
		mDisplayFrame.setTitle("RandomBoids Display");

	    mDisplayFrame.getContentPane().setLayout(new BorderLayout());
        mDisplayFrame.getContentPane().add(mDisplay,BorderLayout.CENTER);

		c.registerFrame(mDisplayFrame);   // register the frame so it appears in the "Display" list
		mDisplayFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		mDisplayFrame.pack();
		mDisplay.frame = mDisplayFrame;
		mDisplayFrame.setVisible(true);
		
	}
	
    public void quit()
    {
		super.quit();
     	mDisplay.detatchAll();
    	mDisplay.destroy();
        if (mDisplayFrame!=null) mDisplayFrame.dispose();
        mDisplayFrame = null;  
        mDisplay = null;       
    }


}
