package sim.app.heatbugs3d;

import sim.app.heatbugs.*;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.*;
import javax.vecmath.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.geometry.*;

//TODO eliminate statics
public class HeatBugPortrayal3D extends SimplePortrayal3D
{
	FieldPortrayal3D parentPortrayal = null;
	static Cylinder c;
	static
	{
	    	Appearance ap = new Appearance();
	    	ap.setColoringAttributes(new ColoringAttributes(1f,1f,1f, ColoringAttributes.SHADE_FLAT));

//	    	/** With "wires" only, you get smaller overall 
//	    	 * frame rate, but also less memory.
//	    	 */
//	    	PolygonAttributes pa = new PolygonAttributes();
//	    	pa.setPolygonMode(PolygonAttributes.POLYGON_LINE);
//	    	ap.setPolygonAttributes(pa);
//	
			c = new Cylinder(0.5f, 1f, Cylinder.GENERATE_NORMALS, 6, 1, ap);
			
	
			setPickableFlags(c.getShape(Cylinder.BODY));
			setPickableFlags(c.getShape(Cylinder.TOP));
			setPickableFlags(c.getShape(Cylinder.BOTTOM));		
	}
	
	public HeatBugPortrayal3D(){}

	public TransformGroup getModel(Object obj, TransformGroup j3dModel)
	{
		if(j3dModel  == null)
		{
//	    	the cylinder is centered in origin, along the Y axis.
//			=> I rotate around X for PI/2, and translate [0,0,0.5]
//			because I want it around the X axis and on the positive side of Z
			Transform3D t = new Transform3D();
			t.setTranslation(new Vector3f(0,0,0.5f));
			t.setRotation(new AxisAngle4d(1,0,0,Math.PI/2));
			TransformGroup tg = new TransformGroup(t);

			LocationWrapper pickI = new LocationWrapper((HeatBug)obj, null, parentPortrayal);

			Cylinder cc = (Cylinder)c.cloneTree();
			cc.getShape(Cylinder.BODY).setUserData(pickI);
			cc.getShape(Cylinder.TOP).setUserData(pickI);
			cc.getShape(Cylinder.BOTTOM).setUserData(pickI);
			
			tg.addChild(cc);
			j3dModel = new TransformGroup();
			j3dModel.addChild(tg);
			
		}
		return j3dModel;
	}
 	public void setParentPortrayal(FieldPortrayal3D p)
 	{
 		parentPortrayal = p;	
 	}
 	public String getName(Object object)
 	{
 		return "HeatBug";
 	}
}