package sim.app.heatbugs3d;

import sim.engine.*;
import sim.display.*;
import sim.display3d.*;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;
import sim.portrayal3d.grid.fastgridcell.*;
import sim.app.heatbugs.*;
import java.awt.*;
import javax.swing.*;


/**
 * @author Gabriel Catalin Balan
 *
 * This is a HeatBugs view. 
 * 	-the bugs can be displayed STACKED or CLASSICAL way (only one shown 
 *	 when more on top of one another).
 *	-the heat is both color and altitude coded. You can turn off
 *   altitudes by using NOZ.	  
 */
public class HeatBugs3DWithUI extends GUIState/*/HeatBugsWithUI*/
{
                
	public JFrame mDisplayFrame; 
	public static final int CLASSIC = 0;
	public static final int STACKED = 1;
	
	public static final int TILE = 0;
	public static final int MESH = 1;
	public static final int NOZ  = 2;

//    DoubleGrid2DPortrayal3D heatPortrayal = null;
	ValueGrid2D3DPortrayal heatPortrayal = null;
    FieldPortrayal3D bugPortrayal = null;
	GridCellQuadPortrayal quadP = null;
     
    public static void main(String[] args)
	{
		HeatBugs3DWithUI heatbugs = 
						new HeatBugs3DWithUI(	new HeatBugs( System.currentTimeMillis(),
        													100,100,100),
//        													HeatBugsWith3DUI.CLASSIC,
															HeatBugs3DWithUI.STACKED, 
//        													HeatBugsWith3DUI.TILE);
//															HeatBugsWith3DUI.NOZ);
															HeatBugs3DWithUI.MESH);
        													
		Console c = new Console(heatbugs);
		c.setVisible(true);        
	}

    public HeatBugs3DWithUI() 
    { 
    	this(new HeatBugs(System.currentTimeMillis()), STACKED, MESH); 
    }

	public HeatBugs3DWithUI(SimState state, final int bugmode, final int heatmode)
	{
		super(state); 
		HeatBugs hb = (HeatBugs) state;
		heatPortrayal = new ValueGrid2D3DPortrayal(hb.valgrid,hb.gridWidth, hb.gridHeight);
		SimpleColorInterpolator cc = new SimpleColorInterpolator();
		cc.setLevels(0.0,HeatBugs.MAX_HEAT,Color.blue,Color.red);
		
		switch(heatmode)
		{
			case TILE : quadP = new TileGridCellPortrayal(3, cc);break;
			case MESH :	quadP = new MeshCellPortrayal(3, cc, hb.gridWidth, hb.gridHeight);break;
			case NOZ :	quadP = new NoZGridCellPortrayal(3, cc);break;
		}

		heatPortrayal.setPortrayalForAll(quadP);
		switch(bugmode)
		{
			case STACKED:
				bugPortrayal = new StackedSparse2DPortrayal3D(hb.buggrid, hb.gridWidth, hb.gridHeight);
				break;
			case CLASSIC:
				
				bugPortrayal = new SparseGrid3DPortrayal(hb.buggrid, hb.gridWidth, hb.gridHeight);
				break;
			default:
				throw new RuntimeException("Invalid mode");				
		}
		

	}
    
    private void setDisplayPreferredSize(){    
		mDisplay.setPreferredSize(new Dimension(600,600));
    }
    
	public String getInfo()
	{ 
		HeatBugs hb = (HeatBugs) state;
		return "<H2>HeatBugs</H2>by Sean Luke & Gabriel Balan.<p>Part of the little simulator we're building.  Let's test the HTML output.  For the heck, the current values are:" +
		"<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
		"<tr><td>Min Ideal Temperature</td><td>" + HeatBugs.minIdealTemp  + "</td></tr>" +
		"<tr><td>Max Ideal Temperature</td><td>" + HeatBugs.maxIdealTemp  + "</td></tr>" +
		"<tr><td>Min Heat Output</td><td>" + HeatBugs.minOutputHeat  + "</td></tr>" +
		"<tr><td>Max Heat Output</td><td>" + HeatBugs.maxOutputHeat  + "</td></tr>" +
		"<tr><td>Evaporation Constant</td><td>" + HeatBugs.evaporationRate + "</td></tr>" +
		"<tr><td>Diffusion Constant</td><td>" + HeatBugs.diffusionRate  + "</td></tr>" +
		"<tr><td>Max Heat</td><td>" + HeatBugs.MAX_HEAT  + "</td></tr>" +
		"<tr><td>Grid Height</td><td>" + hb.gridHeight  + "</td></tr>" +
		"<tr><td>Grid Width</td><td>" + hb.gridWidth  + "</td></tr>" +
		"<tr><td>Number of bugs</td><td>" + hb.bugCount  + "</td></tr>" +
		"<tr><td>Random Movement Probability</td><td>" + HeatBugs.randomMovementProbability + "</td></tr>" +
		"</table>";
	}
	public void start()
    {
    	super.start();
        setup3DPortrayals();
		mDisplay.step(state);
    }
     
	public void load(SimState state)
	{
		super.load(state);
		// we now have new grids.  Set up the portrayals to reflect that
		setup3DPortrayals();
	}
        
    public void setup3DPortrayals()
    {    	
		heatPortrayal.setField(((HeatBugs)state).valgrid);
		bugPortrayal.setField(((HeatBugs)state).buggrid);
		bugPortrayal.setPortrayalForAll(new HeatBugPortrayal3D());

        // reschedule the displayer
        mDisplay.reset();        
    }
    
	public Display3D mDisplay;

	public void init(Controller c)
	{
		super.init(c);
		// Make the Display2D.  We'll have it display stuff later.
		mDisplay = new Display3D(600,600,this,1);
		
        // attach the portrayals to the displayer, from bottom to top
        mDisplay.attach(heatPortrayal,"Heat");
        mDisplay.attach(bugPortrayal, "Bugs");
        heatPortrayal.valueName = "Heat";
        

		mDisplay.createSceneGraph(true);
		mDisplay.setOrbitBehaviorEnabled(true);

        setDisplayPreferredSize();
		mDisplayFrame = mDisplay.createFrame();	
		c.registerFrame(mDisplayFrame);   // register the frame so it appears in the "Display" list
		mDisplayFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		mDisplayFrame.setVisible(true);
	}
	
    public void quit()
    {
		super.quit();
     	mDisplay.detatchAll();
    	mDisplay.destroy();
        if (mDisplayFrame!=null) mDisplayFrame.dispose();
        mDisplayFrame = null;  
        mDisplay = null;       
    }


}