package sim.app.heatbugs3d;

import sim.util.*;
import sim.portrayal.*;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;
import sim.portrayal3d.simple.*;
import sim.field.grid.*;
import java.awt.geom.*;
import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * @author Gabriel Balan
 * 
 * This displays the objects sharing location one on top of the other
 * It assumes interchangeable portrayals for all objects
 * 
 */
public class StackedSparse2DPortrayal3D extends SparseGrid3DPortrayal
{
    
//    public SparseGrid2D grid;
	public Rectangle2D.Double bounds;

    public StackedSparse2DPortrayal3D(SparseGrid2D field,  double width, double height)
	{
		this(field, new Rectangle2D.Double(0,0,width,height));
	}

    public StackedSparse2DPortrayal3D(SparseGrid2D field, double x, double y, double width, double height)
	{
		this(field, new Rectangle2D.Double(x,y,width,height));
	}

    public StackedSparse2DPortrayal3D(SparseGrid2D field, Rectangle2D.Double bounds)
	{
		super(field, GridDefaultTransform.getDefaultGrid2DTransform(bounds.width, bounds.height));
		this.bounds = bounds;
//		portray(field);
	}

    public void portray(Object grid)
	{
		if (grid instanceof SparseGrid2D) 
		    this.field = (SparseGrid2D) grid;
		else throw new RuntimeException("SparseGrid2DPortrayal3D cannot portray the object: " + grid);
	}

	static Portrayal3D defaultPortrayal = new CubePortrayal3D();


    public Portrayal getDefaultPortrayal()
    {
		return defaultPortrayal;
    }
    
	/** to avoid allocating Vector3ds over and over again */
	protected Vector3d tmpV3D = new Vector3d();
	/** tmp Transform3D object, it gets copied in the tranformGroups, so I'll reuse it*/
	protected Transform3D tmpLocalT = new Transform3D();
	
    public TransformGroup createModel(){
		SparseGrid2D grid = (SparseGrid2D)field;
 		TransformGroup globalTG = new TransformGroup();
		for(int x =(int)bounds.x; x< bounds.width; ++ x)
		{
			tmpV3D.x = (double)x-bounds.x;
			for(int y =(int)bounds.y; y< bounds.height; ++y)
			{
				Bag melee = grid.getObjectsAtLocation(x, y);
				tmpV3D.y = (double)y -bounds.y;
				if(melee != null)
					for(int z = 0; z<melee.numObjs; z++)
					{
						tmpV3D.z = z;
						tmpLocalT.setTranslation(tmpV3D);

						//wrap the TG in a BG so it can be removed dynamically
						BranchGroup localBG = InsertModelForNewObject(melee.objs[z], tmpLocalT);			
						globalTG.addChild(localBG);
					}
			}
		}
		
		globalTG.setTransform(overallT);
		globalTG.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		globalTG.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		globalTG.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		
		TransformGroup modelTG = new TransformGroup();
		modelTG.addChild(globalTG);
		modelTG.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
    	return modelTG;
    }
    
    public TransformGroup getModel(Object obj, TransformGroup modelTG){
 		if(modelTG == null)
 			return createModel();

		SparseGrid2D grid = (SparseGrid2D)field;	

		TransformGroup globalTG = (TransformGroup)modelTG.getChild(0);
		
		int existingTrees = globalTG.numChildren();
		int currentIndex=0;
 		
		for(int x=(int)bounds.x; x< bounds.width; ++ x)
		{
			tmpV3D.x = (double)x-bounds.x;
			for(int y=(int)bounds.y; y< bounds.height; ++y)
			{
				tmpV3D.y = (double)y-bounds.y;
				Bag melee = grid.getObjectsAtLocation(x, y);
				if(melee != null)
					for(int z = 0; z<melee.numObjs; z++)
					{
						tmpV3D.z = z;
						tmpLocalT.setTranslation(tmpV3D);

                        BranchGroup localBG;
						if(currentIndex<existingTrees)
						{
							Portrayal p = getPortrayalForObject(melee.objs[z]);
							if(! (p instanceof Portrayal3D))
								throw new RuntimeException("Unexpected Portrayal " + p + " for object " + 
											melee.objs[z] + " -- expecting a PortrayalJ3D");
	                        Portrayal3D p3d = (Portrayal3D)p;
							localBG = (BranchGroup)globalTG.getChild(currentIndex++);
							TransformGroup oldTG = (TransformGroup)localBG.getChild(0);
							TransformGroup localTG = p3d.getModel(melee.objs[z], oldTG);
							localTG.setTransform(tmpLocalT);
						}
						else
						{
							//new objects, generate new trees						
							localBG = InsertModelForNewObject(melee.objs[z],tmpLocalT);
							globalTG.addChild(localBG);
						}
					}
			}
		}
		
		//if(currentIndex<existingTrees) some object have disapear, remove the trees;
		for(int i= existingTrees-1; i>=currentIndex;i--)
			globalTG.removeChild(i);
		return modelTG;
    }
}
    
    