// Class Bot
package sim.app.keepaway;
import java.awt.*;
import sim.portrayal.*;
import sim.util.*;
import sim.engine.*;

public /*strictfp*/ class Bot extends Entity implements Steppable
{
    public Bot( final double x, final double y, Color c)
    {
        super(x,y,2,c);
    }

    public void draw(Object object,  final Graphics2D g, final DrawInfo2D info )
        {
        // draw the circle
        super.draw(object, g,info);
        
        // draw our line as well
        
        final double width = info.draw.width * radius * 2;
        final double height = info.draw.height * radius * 2;
    
        /*
        final int x = (int)(info.draw.x - width / 2.0);
        final int y = (int)(info.draw.y - height / 2.0);
        final int w = (int)(width);
        final int h = (int)(height);

        g.setColor(c);
        g.fillOval(x,y,w,h);
        */
        
        g.setColor(Color.white);
        double d = velocity.angle();
        g.drawLine((int)info.draw.x,
                    (int)info.draw.y,
                    (int)(info.draw.x) + (int)(width/2 * /*Strict*/Math.cos(d)),
                    (int)(info.draw.y) + (int)(height/2 * /*Strict*/Math.sin(d)));
    }
 
    public Vector2D getForces( final Keepaway keepaway)
    {
        Bag objs = keepaway.fieldEnvironment.getObjectsWithinDistance(new Double2D(loc.x, loc.y), 100);

        double dist = 0;

        Vector2D sumVector = new Vector2D(0,0);
        Vector2D tempVector = new Vector2D(0,0);
        
        //http://www.martinb.com/physics/dynamics/collision/twod/index.htm
        double mass1;
        double mass2;

        for(int x=0; x<objs.numObjs; x++)
        {
            if(objs.objs[x] != this)
            {               
                dist = ((Entity)objs.objs[x]).loc.getDistTo(loc);
                    
                if((((Entity)objs.objs[x]).radius + radius)*1.25 > dist)  // collision!
                {
                    // 10% chance of kicking the ball, if it's a ball
                    // and kicking is not especially interesting.. its just accelerated impact
                    if(objs.objs[x] instanceof Ball && keepaway.random.nextDouble() < .1)
                    {
                        tempVector = loc.subtract(((Entity)objs.objs[x]).loc);
                        tempVector.setLength(2.0);
                        ((Entity)objs.objs[x]).velocity.x += -tempVector.x;
                        ((Entity)objs.objs[x]).velocity.y += -tempVector.y;
                    }
                    else	// else just ram it...
                    {		// shouldnt matter what type of object collision occurrs with
                        tempVector.x = 0;
                        tempVector.y = 0;
                        
                        mass1 = mass - ((Entity)objs.objs[x]).mass;
                        mass1 /= (mass + ((Entity)objs.objs[x]).mass);
                        
                        mass2 = 2 * ((Entity)objs.objs[x]).mass;
                        mass2 /= (mass + ((Entity)objs.objs[x]).mass);
                        
                        // self = object a
                        tempVector.x = velocity.x * mass1 + ((Entity)objs.objs[x]).velocity.x * mass2;
                        tempVector.y = velocity.y * mass1 + ((Entity)objs.objs[x]).velocity.y * mass2;
                        
                        // collided object = object 
                        ((Entity)objs.objs[x]).bump.x = velocity.x * mass2 - ((Entity)objs.objs[x]).velocity.x * mass1;
                        ((Entity)objs.objs[x]).bump.y = velocity.y * mass2 - ((Entity)objs.objs[x]).velocity.y * mass1;
                        
                        //sumVector = sumVector.add(tempVector);
                        velocity.x = tempVector.x;
                        velocity.y = tempVector.y;
                    }
                }
                else if(objs.objs[x] instanceof Ball)
                {
                    // if we didn't hit the ball, we want to go towards it
                    tempVector = new Vector2D(0,0);
                    tempVector = ((Entity)objs.objs[x]).loc.subtract(loc);
                    tempVector = tempVector.setLength(0.5);
                    sumVector = sumVector.add(tempVector);
                }
            }
        }
        // bump forces
        sumVector = sumVector.add(bump);
        bump.x = 0;
        bump.y = 0;
        return sumVector;
    }
 
    public void step( final SimState state )
    {
        Keepaway keepaway = (Keepaway)state;
        
       	// get force
        Vector2D force = getForces(keepaway);
        
        // acceleration = f/m
        Vector2D accel = new Vector2D(force.x/mass,force.y/mass);
        
        // v = v + a
        velocity = velocity.add(accel);
        capVelocity();
        
        // L = L + v
        Vector2D newLoc = new Vector2D( loc.x + velocity.x, loc.y + velocity.y);
        
        // is new location valid?
        if(isValidMove(keepaway, newLoc))
            loc = newLoc;
        
        keepaway.fieldEnvironment.setObjectLocation(this, new Double2D(loc.x, loc.y));
    }
}