package sim.app.lsystem;
import sim.engine.*;
import sim.field.continuous.*;
import ec.util.*;
import java.io.*;

public /*strictfp*/ class Lsystem extends SimState
{
    /** @todo handle realocation of grids when these two are changed */
    public double xMin = 0;
    public double xMax = 100;
    public double yMin = 0;
    public double yMax = 100;
    
    public Lsys l = new Lsys();
    
    public Continuous2D drawEnvironment;
    

    public Lsystem(long seed)
    {
        this(seed, 100, 100);
    }
        
    public Lsystem(long seed, int width, int height)
    {
        super(new MersenneTwisterFast(seed), new Schedule(2));
        xMax = width; yMax = height;
        
        createGrids();
    }

    void createGrids()
    {	
        drawEnvironment = new Continuous2D(5, (xMax - xMin), (yMax - yMin));
    }
    
    /** Resets and starts a simulation */
    public void start()
    {
        super.start();  // clear out the schedule
        createGrids();

        LsysDrawer ld = new LsysDrawer(l);
        ld.stopper = schedule.scheduleRepeating(ld);
    }
    
    
    public static void main(String[] args)
    {
        Lsystem lsystem = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
            {
                SimState state = SimState.readFromCheckpoint(new File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof Lsystem))  // uh oh, wrong simulation stored in the file!
                {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                }
                else // we're ready to lock and load!  
                    lsystem = (Lsystem)state;
            }
        
        // ...or should we start fresh?
        if (lsystem==null)  // no checkpoint file requested
        {
            lsystem = new Lsystem(System.currentTimeMillis());  // make a new lsystem.  Seed the RNG with the time
            lsystem.start();  // prep the bugs!
            System.out.println("Starting Lsystem.  Running for 5000 steps.");
        }
        
        long time;
        while((time = lsystem.schedule.time()) < 5000)
        {
            // step the schedule.  This is where everything happens.
            if (!lsystem.schedule.step(lsystem)) break;   // it won't happen that we end prematurely,
                                                            // but it's worth checking for!

            if (time%100==0 && time!=0) 
		System.out.println("Time Step " + time);
        
            // checkpoint
            if (time%500==0 && time!=0)
            {
                String s = "ls." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                lsystem.writeToCheckpoint(new File(s));
            }
        }
            
        lsystem.finish();  // we don't use this, but it's good style
    }
}
    
    
    
    
    
