package sim.app.mousetraps;
import sim.engine.*;
import sim.display.*;
import sim.portrayal.grid.*;
import java.awt.*;
import javax.swing.*;

public class MouseTrapsWithUI extends GUIState
{
	public Display2D display;
	public JFrame displayFrame;
	
	FastValueGrid2DPortrayal trapPortrayal = new FastValueGrid2DPortrayal("Traps");
	
	public static void main(String[] args)
    {
	    MouseTrapsWithUI sim = new MouseTrapsWithUI();
	    Console c = new Console(sim);
	    c.setVisible(true);
    }
	
	public MouseTrapsWithUI() { super(new MouseTraps(System.currentTimeMillis())); }
	public MouseTrapsWithUI(SimState state) { super(state); }
	public String getName() { return "Mouse Traps"; }
	
	public String getInfo()
    {
	    MouseTraps sim = (MouseTraps) state;
	    
	    return 
	    "<H2>Mouse Traps</H2>by Gabriel Balan.<p>" +
	    "<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
	    "<tr><td>Number of balls on a trap </td><td>" + MouseTraps.BALLS_PER_TRAP  + "</td></tr>" +
	    "<tr><td>Initial velocity of ball leaving a trap</td><td>" + sim.initialVelocity  + "</td></tr>" +
	    "<tr><td>Number of traps</td><td>" + sim.trapGridWidth+" x "+ sim.trapGridHeight + "</td></tr>" +
	    "</table>"; 
	    }
	
	public void start()
	    {
	    super.start();
	    // set up our portrayals
	    setupPortrayals();
	    }
	
	public void load(SimState state)
	    {
	    super.load(state);
	    // we now have new grids.  Set up the portrayals to reflect that
	    setupPortrayals();
	    }
	    
	// This is called by start() and by load() because they both had this code
	// so I didn't have to type it twice :-)
	public void setupPortrayals()
	    {
	    // tell the portrayals what to portray and how to portray them
	    trapPortrayal.setField(((MouseTraps)state).trapStateGrid);
	    trapPortrayal.setLevels(0,1,Color.black,Color.red);
	        
	    // reschedule the displayer
	    display.reset();
	            
	    // redraw the display
	    display.repaint();
	    }
	
	public void init(Controller c)
	    {
	    super.init(c);
	    
	    // Make the Display2D.  We'll have it display stuff later.
	    display = new Display2D(400,400,this,1); // at 400x400, we've got 4x4 per array position
	    displayFrame = display.createFrame();
	    c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
	    displayFrame.setVisible(true);
	
	    // attach the portrayals
	    display.attach(trapPortrayal,"Traps");
	
	    // specify the backdrop color  -- what gets painted behind the displays
	    display.setBackdrop(Color.black);
	    }
	    
	public void quit()
	    {
	    super.quit();
	    
	    if (displayFrame!=null) displayFrame.dispose();
	    displayFrame = null;  // let gc
	    display = null;       // let gc
	    }
}
	
	
	
	
	
