package sim.app.mousetraps3d;

import sim.engine.*;
import sim.display.*;
import sim.display3d.*;
import sim.app.mousetraps.*;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;
import sim.portrayal3d.simple.*;
import sim.portrayal3d.continuous.*;
import sim.portrayal3d.grid.fastgridcell.*;
import java.awt.*;
import javax.vecmath.*;
import javax.media.j3d.*;
import javax.swing.*;

public class MouseTraps3DWithUI extends GUIState
{
	public JFrame mDisplayFrame; 
	
	ValueGrid2D3DPortrayal trapsPortrayal = null;
	Continuous3DPortrayal ballPortrayal = null;
	WireFrameBoxPortrayal3D wireFrameP;

	public static void main(String[] args)
	{
		MouseTraps3DWithUI simGUI = new MouseTraps3DWithUI(	new MouseTraps( System.currentTimeMillis(),
	    													40.0,15,10,120.0,80.0,false));
	    													
		Console c = new Console(simGUI);
		c.setVisible(true);        
	}
	
	public MouseTraps3DWithUI() 
	{ 
		this(new MouseTraps(System.currentTimeMillis(), 3.9,100,100,10.0,10.0,false)); 
	}
	
	public MouseTraps3DWithUI(SimState state)
	{
		super(state); 
		MouseTraps sim = (MouseTraps) state;
		double width = sim.trapGridWidth;
		double height = sim.trapGridHeight;
		double length = sim.spaceLength* Math.max(width, height)/Math.max(sim.spaceWidth, sim.spaceHeight);
		
		double scale = 1;
		Transform3D bottomT = new Transform3D();
		double scaleFactor = scale/Math.max(height, Math.max(width, length));
		bottomT.setTranslation(new Vector3d(-0.5*scaleFactor*(width-1), 
											-0.5*scaleFactor*(height-1),
											-0.5*scaleFactor*length));
		bottomT.setScale(scaleFactor);
		trapsPortrayal = new ValueGrid2D3DPortrayal(sim.trapStateGrid,bottomT);
		SimpleColorInterpolator cc = new SimpleColorInterpolator();
		cc.setLevels(0.0,1.0,Color.blue,Color.gray);
		trapsPortrayal.setPortrayalForAll(new NoZGridCellPortrayal(3, cc));

		ballPortrayal = new Continuous3DPortrayal(sim.ballSpace, sim.spaceWidth, sim.spaceHeight, sim.spaceLength);
		wireFrameP = new WireFrameBoxPortrayal3D(	sim.spaceWidth, 
													sim.spaceHeight, 
													sim.spaceLength, 
													1.0/Math.max(sim.spaceWidth, Math.max(sim.spaceHeight, sim.spaceLength)));

	}
	
	private void setDisplayPreferredSize(){    
		mDisplay.setPreferredSize(new Dimension(600,600));
	}
	
	public String getInfo()
	{ 
		MouseTraps sim = (MouseTraps) state;
		return 	    "<H2>Mouse Traps</H2>by Gabriel Balan." +
	    "<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
	    "<tr><td>Number of balls on a trap </td><td>" + MouseTraps.BALLS_PER_TRAP  + "</td></tr>" +
	    "<tr><td>Initial velocity of ball leaving a trap</td><td>" + sim.initialVelocity  + "</td></tr>" +
	    "<tr><td>Number of traps</td><td>" + sim.trapGridWidth+" x "+ sim.trapGridHeight + "</td></tr>" +
	    "</table>"; 

	}
	public void start()
	{
		super.start();
	    setup3DPortrayals();
		mDisplay.step(state);        
	}
	 
	public void load(SimState state)
	{
		super.load(state);
		// we now have new grids.  Set up the portrayals to reflect that
		setup3DPortrayals();
	}
	    
	public void setup3DPortrayals()
	{    	
		trapsPortrayal.setField(((MouseTraps)state).trapStateGrid);
		ballPortrayal.setField(((MouseTraps)state).ballSpace);
		ballPortrayal.setPortrayalForAll(new SpherePortrayal3D(new Color3f(Color.green)));
	
	    // reschedule the displayer
	    mDisplay.reset();        
	}
	
	public Display3D mDisplay;
	
	public void init(Controller c)
	{
		super.init(c);
		// Make the Display2D.  We'll have it display stuff later.
		mDisplay = new Display3D(600,600,this,1);
		
	    // attach the portrayals to the displayer, from bottom to top
	    mDisplay.attach(trapsPortrayal,"Traps");
	    mDisplay.attach(ballPortrayal, "Balls");
		mDisplay.attach(wireFrameP, "Fish tank");

	    
	
		mDisplay.createSceneGraph(false);
		mDisplay.setOrbitBehaviorEnabled(true);
	
	    setDisplayPreferredSize();
		mDisplayFrame = new JFrame();		
		mDisplayFrame.setTitle("MouseTraps 3D Display");
	
	    mDisplayFrame.getContentPane().setLayout(new BorderLayout());
	    mDisplayFrame.getContentPane().add(mDisplay,BorderLayout.CENTER);
	
		c.registerFrame(mDisplayFrame);   // register the frame so it appears in the "Display" list
		mDisplayFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		mDisplayFrame.pack();
		mDisplay.frame = mDisplayFrame;
		mDisplayFrame.setVisible(true);
	//		mDisplay.step(state);
	}
	
	public void quit()
	{
		super.quit();
	 	mDisplay.detatchAll();
		mDisplay.destroy();
	    if (mDisplayFrame!=null) mDisplayFrame.dispose();
	    mDisplayFrame = null;  
	    mDisplay = null;       
	}
	
	
}
