package sim.app.networktest;

import sim.engine.*;
import sim.util.Double2D;
import sim.portrayal.*;
import java.awt.geom.*;
import java.awt.*;

public /*strictfp*/ class CustomNode extends SimplePortrayal2D implements Steppable
{

    public String id;
    public String getID() { return id; }
    public void setID( final String id ) { this.id = id; }

    public Double2D location; 

    public CustomNode( String id, Double2D location )
    {
        this.id = id;
        this.location = location;
    }

    Double2D desiredLocation = null;
    Double2D suggestedLocation = null;
    int steps = 0;

    public void step( final SimState state )
    {
        NetworkTest nt = (NetworkTest)state;

        steps--;
        if( desiredLocation == null || steps <= 0 )
        {
            desiredLocation = new Double2D((state.random.nextDouble()-0.5)*((NetworkTest.XMAX-NetworkTest.XMIN)/5-NetworkTest.DIAMETER) +
                                           //NetworkTest.XMIN
                                           location.x 
                                           //+NetworkTest.DIAMETER/2
                                           ,
                                           (state.random.nextDouble()-0.5)*((NetworkTest.YMAX-NetworkTest.YMIN)/5-NetworkTest.DIAMETER) +
                                           location.y
                                           //NetworkTest.YMIN
                                           //+NetworkTest.DIAMETER/2
                                           );
            steps = 50+state.random.nextInt(50);
        }

        double dx = desiredLocation.x - location.x;
        double dy = desiredLocation.y - location.y;

        {
            double temp = /*Strict*/Math.sqrt(dx*dx+dy*dy);
            if( temp < 1 )
            {
                steps = 0;
            }
            else
            {
                dx /= temp;
                dy /= temp;
            }
        }

        if( ! nt.acceptablePosition( this, new Double2D( location.x + dx, location.y + dy ) ) )
        {
            steps = 0;
        }
        else
        {
            location = new Double2D(location.x + dx, location.y + dy);
            nt.environment.setObjectLocation(this,location);
        }

    }

    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info)
    {
        double diamx = info.draw.width*NetworkTest.DIAMETER;
        double diamy = info.draw.height*NetworkTest.DIAMETER;

        graphics.setColor( Color.red );
        graphics.fillOval((int)(info.draw.x-diamx/2),(int)(info.draw.y-diamy/2),(int)(diamx),(int)(diamy));
        graphics.setColor( Color.blue );
        graphics.drawString( id, (int)(info.draw.x-diamx/2), (int)(info.draw.y-diamy/2) );
    }

    public boolean hitObject(Object object, DrawInfo2D info)
    {
        double diamx = info.draw.width*NetworkTest.DIAMETER;
        double diamy = info.draw.height*NetworkTest.DIAMETER;

        Ellipse2D.Double ellipse = new Ellipse2D.Double( (int)(info.draw.x-diamx/2),(int)(info.draw.y-diamy/2),(int)(diamx),(int)(diamy) );
        return ( ellipse.intersects( info.clip.x, info.clip.y, info.clip.width, info.clip.height ) ); 
    }

}
