package sim.app.woims;

import java.awt.*;
import sim.portrayal.*;

public /*strictfp*/ class Obstacle extends SimplePortrayal2D
{
    protected Paint obstacleColor = new Color(192,255,192);
    // gradient obstacles!  Try it!  Slower but fun!
    //protected Paint obstacleColor = new GradientPaint(0,0,Color.red,10,10,Color.green,true);

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info)
        {
        graphics.setPaint(obstacleColor);
        // we are doing a simple draw, so we ignore the info.clip

        int x = (int)(info.draw.x - info.draw.width*diameter / 2.0);
        int y = (int)(info.draw.y - info.draw.height*diameter / 2.0);
        int width = (int)(info.draw.width*diameter);
        int height = (int)(info.draw.height*diameter);

        // draw centered on the origin
        graphics.fillOval(x,y,width, height);
        }

    public Obstacle( double diam )
    {
        this.diameter = diam;
    }

    double diameter;

}
