package sim.app.woims;


import sim.portrayal.continuous.*;
import sim.engine.*;
import sim.display.*;
import javax.swing.*;
import java.awt.Color;

public class WoimsDemoWithUI extends GUIState
    {

    public Display2D display;
    public JFrame displayFrame;

    Continuous2DPortrayal woimsPortrayal = new Continuous2DPortrayal();
    Continuous2DPortrayal obstaclesPortrayal = new Continuous2DPortrayal();

    public static void main(String[] args)
        {
        WoimsDemoWithUI woims = new WoimsDemoWithUI();
        Console c = new Console(woims);
        c.setVisible(true);
        }

    public WoimsDemoWithUI() { super(new WoimsDemo( System.currentTimeMillis())); }
    public WoimsDemoWithUI(SimState state) { super(state); }

    public String getName() { return "Woims"; }

    public String getInfo()
    {
        WoimsDemo ws = (WoimsDemo) state;

        return
        "<H2>Woims</H2>by Liviu Panait.<p>Parameters:" +
        "<tr><td>Number of Woims</td><td>" + WoimsDemo.NUM_WOIMS  + "</td></tr>" +
        "</table>";
    }

    public void start()
    {
        super.start();
        setupPortrayals();
    }

    public void load(SimState state)
        {
        super.load(state);
        setupPortrayals();
        }
        
    public void setupPortrayals()
        {
        // tell the portrayals what to portray and how to portray them
        woimsPortrayal.setField(((WoimsDemo)state).woimsEnvironment);
        obstaclesPortrayal.setField(((WoimsDemo)state).obstaclesEnvironment);

        // reschedule the displayer
        display.reset();
        display.setBackdrop(Color.white);
                
        // redraw the display
        display.repaint();
        }

    public void init(Controller c)
        {
        super.init(c);

        // make the displayer
        display = new Display2D(600,600,this,1);

        displayFrame = display.createFrame();
        displayFrame.setTitle("Woims Demonstration Display");
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);
        display.attach( woimsPortrayal, "Woims" );
        display.attach( obstaclesPortrayal, "Obstacles" );
        }
        
    public void quit()
        {
        super.quit();
        
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;
        display = null;
        }

    }