package sim.app.woims3d;

import sim.portrayal3d.continuous.*;
import sim.portrayal3d.simple.*;
import sim.engine.*;
import sim.display.*;
import sim.display3d.*;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.*;
import java.awt.*;

public class WoimsDemo3DWithUI extends GUIState
    {
    public Display3D display;
    public JFrame displayFrame;

    public String getName() { return "Woims Demonstration!"; }

	public String getInfo()  // we'll just assume it's HTML
    {
        WoimsDemo3D wd = (WoimsDemo3D) state;
 
            return "<H2>Woims Demonstration</H2>by Liviu Panait & Gabriel Balan.<p>Parameters:" +
        "<tr><td>Number of Woims</td><td>" + WoimsDemo3D.NUM_WOIMS  + "</td></tr>" +
        "</table>"; 
    }

    public static void main(String[] args)
        {
        WoimsDemo3DWithUI woims = new WoimsDemo3DWithUI(new WoimsDemo3D(System.currentTimeMillis()));
        Console c = new Console(woims);
        c.setVisible(true);
        }
    public WoimsDemo3DWithUI()
    {
    	this(new WoimsDemo3D(System.currentTimeMillis()));
    }

	Continuous3DPortrayal p2;
	DirectionalLightPortrayal3D light;

    public WoimsDemo3DWithUI(SimState state)
	{
        super(state);
        WoimsDemo3D wd = (WoimsDemo3D) state;
        p2 = new Continuous3DPortrayal(wd.environment, WoimsDemo3D.XMAX-WoimsDemo3D.XMIN, WoimsDemo3D.YMAX-WoimsDemo3D.YMIN, WoimsDemo3D.ZMAX-WoimsDemo3D.ZMIN); 
        
        light= new DirectionalLightPortrayal3D(
                            new Color3f(1.0f, 1.0f, 1.0f),
                            new Vector3f(-2.0f, -3.0f, -1.0f));
        light.setInfluencingBounds(new BoundingSphere(new Point3d(0,0,0), 1000d));

    }

        
    public void start()
	{
        super.start();  // clear out the schedule
        setup3DPortrayals();
		display.step(state);
		display.setOrbitBehaviorEnabled(true);
		display.refreshBoundsOnBehaviors();
	}
    public void load(SimState state)
    {
        super.load(state);  // clear out the schedule
        setup3DPortrayals();
    }
    public void setup3DPortrayals()
    {
        WoimsDemo3D wd = (WoimsDemo3D) state;
        p2.setField(wd.environment);
        display.reset();
    }

    public void init(Controller c)
    {
        super.init(c);
        display = new Display3D(600,600,this,1);
        
        display.attach(p2,"Woims");
        display.attach(light, "SpotLight");
        display.createSceneGraph(false);
        //createScene creates an empty scene (the woims and the obstacles are 
        // simply not there, since the fields are empty. => the spin and orbit
        // behaviors won't work, because they relay on the empty bounds of the scene
        //
        // => I refresh the bounds in start()

        
        setDisplayPreferredSize();
        displayFrame = new JFrame();       
        
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add(display,BorderLayout.CENTER);

        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
        displayFrame.pack();
        display.frame = displayFrame;
        displayFrame.setTitle("Woims Display");
        displayFrame.setVisible(true);
	}
    private void setDisplayPreferredSize()
    {    
		display.setPreferredSize(new Dimension(600,600));
    }        
    public void quit()
    {
		super.quit();
     	display.detatchAll();
    	display.destroy();
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;  
        display = null;    
    }
}