package sim.display;
import java.applet.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** A simple class for creating Applets out of your simulations.  Due to security restrictions,
    certain things will not work, such as reading files (loading models) or writing files
    (producing movies etc.).
    
    <p>You can check to see if you're running under an applet by testing the value of
    SimApplet.isApplet
    */
public class SimApplet extends Applet 
    {
    
    public static boolean isApplet = false;
    public SimApplet() { isApplet = true; }
    
    public void init() 
        {
        String simClassName = getParameter("Simulation");
        String simHumanName = getParameter("Name");
        final JButton button = new JButton("Start " + simHumanName + " Simulation");
        setLayout(new BorderLayout());
        add(button, BorderLayout.CENTER);
        try
            {
            // load that class
            final Class simClass = Class.forName(simClassName);
            if (!(GUIState.class.isAssignableFrom(simClass)))  // if it's not a GUIState
                throw new Exception("Class is not a GUIState: " + simClass);
            button.addActionListener(new ActionListener()
                {
                public void actionPerformed(ActionEvent evt)
                    {
                    try
                        {
                        setupApplet(simClass);
                        }
                    catch (Exception e)
                        {
                        doException(button,e);
                        }
                    }
                });
            }
        catch (Exception e)
            {
            doException(button,e);
            }
        }
        
    public void setupApplet(Class GUIStateClass) throws Exception  // yes, purposely capitalized
        {
        GUIState state = (GUIState)(GUIStateClass.newInstance());
        Console c = new Console(state);
        c.setVisible(true);
        }
    
    public void doException(JComponent button, Exception e)
        {
        JTextArea text = new JTextArea();
        text.setText("" + e);
        JScrollPane scroll = new JScrollPane(text);
        if (button != null) remove(button);
        add(scroll,BorderLayout.CENTER);
        e.printStackTrace();        
        }
    }
