package sim.field.grid;
import sim.util.*;

/**
    A storage facility for objects. Most functionality similar to DoubleGrid2D, just that objects are stored, rather than real-valued numbers.
*/

public class ObjectGrid2D extends AbstractGrid2D
    {
    public Object[/**x*/][/**y*/] field;
    
    public ObjectGrid2D (int xdim, int ydim)
        {
        width = xdim;
        height = ydim;
        field = new Object[xdim][ydim];
        }
    
    public ObjectGrid2D (int xdim, int ydim, Object initialValue)
        {
        this(xdim,ydim);
        setTo(initialValue);
        }
    
    public ObjectGrid2D (ObjectGrid2D values)
        {
        setTo(values);
        }
            
    public final void set(final int x, final int y, final Object val)
        {
        field[x][y] = val;
        }

    public final Object get(final int x, final int y)
        {
        return field[x][y];
        }

    public final ObjectGrid2D setTo(Object thisObj)
        {
        Object[] fieldx = null;
   		final int width = this.width;
		final int height = this.height;
        for(int x=0;x<width;x++)
            {
            fieldx = field[x];
            for(int y = 0; y<height;y++)
                fieldx[y]=thisObj;
            }
        return this;
        }

    public final ObjectGrid2D setTo(final ObjectGrid2D values)
        {
        if (width != values.width || height != values.height)
            {
            final int width = this.width = values.width;
            final int height = this.height = values.height;
            Object[][] field = this.field = new Object[width][];
            Object[][] ofield = values.field;
            for(int x =0 ; x < width; x++)
                field[x] = (Object []) (ofield[x].clone());
            }
        else
            {
            Object[][] field = this.field;
            Object[][] ofield = values.field;
            for(int x =0 ; x < width; x++)
                System.arraycopy(ofield[x],0,field[x],0,height);
            }
        return this;
        }

    /*
     * Gets all neighbors of a location that satisfy max( abs(x-X) , abs(y-Y) ) <= d
     * Returns the neighbors and their x and y positions; xPos and yPos can be null if you don't care about the x and y positions.
     */
    public final void getNeighborsMaxDistance( final int x, final int y, final int dist, final boolean toroidal, Bag result, IntBag xPos, IntBag yPos )
    {
        if( xPos == null )
            xPos = new IntBag();
        if( yPos == null )
            yPos = new IntBag();

        getNeighborsMaxDistance( x, y, dist, toroidal, xPos, yPos );

        result.clear();
        for( int i = 0 ; i < xPos.numObjs ; i++ )
            result.add( field[xPos.objs[i]][yPos.objs[i]] );
    }

    /*
     * Gets all neighbors of a location that satisfy abs(x-X) + abs(y-Y) <= d
     * Returns the neighbors and their x and y positions; xPos and yPos can be null if you don't care about the x and y positions.
     */
    public final void getNeighborsHamiltonianDistance( final int x, final int y, final int dist, final boolean toroidal, Bag result, IntBag xPos, IntBag yPos )
    {
        if( xPos == null )
            xPos = new IntBag();
        if( yPos == null )
            yPos = new IntBag();

        getNeighborsHamiltonianDistance( x, y, dist, toroidal, xPos, yPos );

        result.clear();
        for( int i = 0 ; i < xPos.numObjs ; i++ )
            result.add( field[xPos.objs[i]][yPos.objs[i]] );
    }

    /*
     * Gets all neighbors of a location in hexagonal world
     * Returns the neighbors and their x and y positions; xPos and yPos can be null if you don't care about the x and y positions.
     */
    public final void getNeighborsHexagonalDistance( final int x, final int y, final int dist, final boolean toroidal, Bag result, IntBag xPos, IntBag yPos )
    {
        if( xPos == null )
            xPos = new IntBag();
        if( yPos == null )
            yPos = new IntBag();

        getNeighborsHexagonalDistance( x, y, dist, toroidal, xPos, yPos );

        result.clear();
        for( int i = 0 ; i < xPos.numObjs ; i++ )
            result.add( field[xPos.objs[i]][yPos.objs[i]] );
    }

    }
