package sim.field.grid;

import sim.util.*;

/**
    A storage facility for objects. Most functionality similar to DoubleGrid3D, just that objects are stored, rather than real-valued numbers.
*/

public class ObjectGrid3D extends AbstractGrid3D
    {
    public Object[/**x*/][/**y*/][/**z*/] field;
    
    public ObjectGrid3D (int xdim, int ydim, int zdim)
        {
        width = xdim;
        height = ydim;
        length = zdim;
        field = new Bag[xdim][ydim][zdim];
        }
    
    public ObjectGrid3D (int xdim, int ydim, int zdim, Object initialValue)
        {
        this(xdim,ydim,zdim);
        setTo(initialValue);
        }
    
    public ObjectGrid3D (ObjectGrid3D values)
        {
        setTo(values);
        }
        
    public final void set(final int x, final int y, final int z, final Object val)
        {
        field[x][y][z] = val;
        }

    public final Object get(final int x, final int y, final int z)
        {
        return field[x][y][z];
        }


    public final ObjectGrid3D setTo(Object thisObj)
        {
        Object[][][] field = this.field;
        Object[][] fieldx = null;
        Object[] fieldxy = null;
        final int width = this.width;
        final int height = this.height;
        final int length = this.length;
        for(int x=0;x<width;x++)
            {
            fieldx = field[x];
            for(int y = 0; y<height;y++)
                {
                fieldxy = fieldx[y];
                for(int z=0;z<length;z++)
                    fieldxy[z]=thisObj;
                }
            }
        return this;
        }

    public final ObjectGrid3D setTo(final ObjectGrid3D values)
        {
        if (width != values.width || height != values.height)
            {
            final int width = this.width = values.width;
            final int height = this.height = values.height;
            final int length = this.length = values.length;
            Object[][][] field = this.field = new Object[width][height][];
            Object[][][] ofield = values.field;
            Object[][] fieldx = null;
            Object[][] ofieldx = null;
            for(int x =0 ; x < width; x++)
                {
                fieldx = field[x];
                ofieldx = ofield[x];
                for(int y=0 ; y < height ; y++)
                    fieldx[y] = (Object[]) (ofieldx[y].clone());
                }
            }
        else
            {
            Object[][][] field = this.field;
            Object[][][] ofield = values.field;
            Object[][] fieldx = null;
            Object[][] ofieldx = null;
            for(int x =0 ; x < width; x++)
                {
                fieldx = field[x];
                ofieldx = ofield[x];
                for(int y=0;y<height;y++)
                    System.arraycopy(ofieldx[y],0,ofieldx[y],0,length);
                }
            }
        return this;
        }

    /*
     * Gets all neighbors of a location that satisfy max( abs(x-X) , abs(y-Y), abs(z-Z) ) <= d
     * Returns the neighbors and their x, y and z positions; xPos, yPos and zPos can be null if you don't care about the x, y and z positions.
     */
    public final void getNeighborsMaxDistance( final int x, final int y, final int z, final int dist, final boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos )
    {
        if( xPos == null )
            xPos = new IntBag();
        if( yPos == null )
            yPos = new IntBag();
        if( zPos == null )
            zPos = new IntBag();

        getNeighborsMaxDistance( x, y, z, dist, toroidal, xPos, yPos, zPos );

        result.clear();
        for( int i = 0 ; i < xPos.numObjs ; i++ )
            result.add( field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]] );
    }

    /*
     * Gets all neighbors of a location that satisfy abs(x-X) + abs(y-Y) + abs(z-Z) <= d
     * Returns the neighbors and their x, y and z positions; xPos, yPos and zPos can be null if you don't care about the x, y and z positions.
     */
    public final void getNeighborsHamiltonianDistance( final int x, final int y, final int z, final int dist, final boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos )
    {
        if( xPos == null )
            xPos = new IntBag();
        if( yPos == null )
            yPos = new IntBag();
        if( zPos == null )
            zPos = new IntBag();

        getNeighborsHamiltonianDistance( x, y, z, dist, toroidal, xPos, yPos, zPos );

        result.clear();
        for( int i = 0 ; i < xPos.numObjs ; i++ )
            result.add( field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]] );
    }

    }
