package sim.portrayal.simple;
import sim.portrayal.*;
import java.awt.*;

/**
    A simple portrayal for 2D visualization of images. It extends the SimplePortrayal2D and
    it manages the drawing and hit-testing for rectangular shapes containing images/pictures.
*/

// if you want something more sophisticated than this (such as responding
// to the color values in a useful fashion) you may need to use Java2D's
// drawImage(BufferedImage img, BufferedImageOp op,  int x, int y) method,
// and that would be expensive.  :-)

// if you want more exact control over the scaling method for the image
// (nearest neighbor vs. bilinear), you can set the KEY_INTERPOLATION
// rendering hint in Java2D.

public class ImagePortrayal2D extends RectanglePortrayal2D
    {
    public Image image;
    
    public ImagePortrayal2D(Image image)  { this(image,1.0); }
    public ImagePortrayal2D(Image image, double scale) 	
        { 
        super(null,scale);  // don't bother with color
        this.image = image;
        this.scale = scale;
        }
        
    // assumes the graphics already has its color set
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info)
        {
        if (image==null) return;
        // in this example we ALWAYS draw the image, even if the color is set to 0 alpha...

        final double width = info.draw.width*scale;
        final double height = info.draw.height*scale;

        final int x = (int)(info.draw.x - width / 2.0);
        final int y = (int)(info.draw.y - height / 2.0);
        final int w = (int)(width);
        final int h = (int)(height);

        // draw centered on the origin
        graphics.drawImage(image,x,y,w,h,null);
        }
        
    }
