package sim.portrayal.simple;
import sim.display.*;
import sim.field.grid.*;
import sim.portrayal.*;
import sim.portrayal.grid.*;
import java.awt.*;
import sim.util.*;

/** 
    The ValuePortrayal2D is the default portrayal for ValueGrid2DPortrayals.
    It requires a parent (the ValueGrid2DPortrayal), which it uses to determine
    the correct colors for a given object.  The objects portrayed must be 
    instances of MutableDouble, where the value represents the level of the color.
*/

public class ValuePortrayal2D extends RectanglePortrayal2D
    {
    public double level;
    public boolean isTransparent;
    public ValueGrid2DPortrayal parent;
    
    public ValuePortrayal2D(ValueGrid2DPortrayal parent)
        {
        super(null);  // no color  -- we'll determine the color during portrayal
        setParent(parent);
        }
    
    public void setParent(ValueGrid2DPortrayal parent)
        {
        this.parent = parent;
        }
    
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info)
        {
        double levelHere = ((MutableDouble)object).val;
        if (paint==null || level != levelHere)
             {
	     Color c = parent.getColor(levelHere);
	     if (c.getAlpha() == 0) isTransparent = true;
	     }
        if (!isTransparent) super.draw(object, graphics, info);
        }
    
    public static abstract class Filter
	{
        int x;
        int y;
        ValueGrid2DPortrayal fieldPortrayal;
        public Filter(LocationWrapper wrapper)
	    {
            fieldPortrayal = (ValueGrid2DPortrayal)(wrapper.getFieldPortrayal());
            Int2D loc = (Int2D)(wrapper.getLocation());
            x = loc.x;
            y = loc.y;
	    }
        }

    // the only reason for these two subclasses is that they differ in the data
    // type of their property (double vs int).  This allows us to guarantee that
    // ints are displayed or set as opposed to doubles in the Inspector.  No
    // big whoop -- it's more a formatting thing than anything else.
    
    public static class DoubleFilter extends Filter
        {
        public DoubleFilter(LocationWrapper wrapper) { super(wrapper); }
        public double getValue() { return ((DoubleGrid2D)fieldPortrayal.field).field[x][y]; }
        public void setValue(double val) { ((DoubleGrid2D)fieldPortrayal.field).field[x][y] = fieldPortrayal.newValue(x,y,val); }
        // static inner classes don't need serialVersionUIDs
        }
        
    public static class IntFilter extends Filter
        {
        public IntFilter(LocationWrapper wrapper) { super(wrapper); }
        public int getValue() { return ((IntGrid2D)fieldPortrayal.field).field[x][y]; }
        public void setValue(int val) { ((IntGrid2D)fieldPortrayal.field).field[x][y] = (int)fieldPortrayal.newValue(x,y,val); }
        // static inner classes don't need serialVersionUIDs
        }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state)
        {
        if (((ValueGrid2DPortrayal)(wrapper.getFieldPortrayal())).field instanceof DoubleGrid2D)
            return new SimpleInspector(new DoubleFilter(wrapper), state, "Properties");
        else
            return new SimpleInspector(new IntFilter(wrapper) ,state, "Properties");
        // static inner classes don't need serialVersionUIDs
        }
    
    public String getName(LocationWrapper wrapper)
        {
        ValueGrid2DPortrayal portrayal = (ValueGrid2DPortrayal)(wrapper.getFieldPortrayal());
        return portrayal.getValueName() + " at " + wrapper.getLocationName();
        }
    }
