package sim.portrayal3d;
import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * @author Gabriel Catalin Balan
 * 
 * It gets the box (xyz) -&gt (x+dx,y+dy, z+dz)
 * inside (-.5-.5-.5) -&gt (.5.5.5) while
 * maintaining the proportions
 *
 * Use this as default tranform for FieldPotrayal3Ds
 * 
 * @see sim.portrayal.grid.GridDefaultTransform for grids.
 **/
public class DefaultTransform
{
	static public Transform3D getDefaultTransform(double x, 
													double y, 
													double z,
													double width,
													double height,
													double length, 
													double scale) 
	{
		Transform3D centerT = new Transform3D();
		double scaleFactor = scale/Math.max(height, Math.max(width,length));
		centerT.setTranslation(new Vector3d(-scaleFactor*(x+width/2), 
											-scaleFactor*(y+height/2),
											-scaleFactor*(z+length/2)));
		centerT.setScale(scaleFactor);
		return centerT;
	}
	
	static public Transform3D getDefaultTransform(double x, 
													double y, 
													double z,
													double width,
													double height,
													double length) 
	{
		return getDefaultTransform(x,y,z,width, height, length, 1);
	}
	
	static public Transform3D getDefaultTransform(double width,
													double height,
													double length,
													double scale) 
	{
		return getDefaultTransform(0,0,0,width, height, length);
	}

	static public Transform3D getDefaultTransform(double width,
													double height,
													double length) 
	{
		return getDefaultTransform(0,0,0,width, height, length, 1);
	}
	
}
