package sim.portrayal3d;
import sim.portrayal.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.picking.*;

/** 
 * Superclass of all Field Portrayals in J3D.  
 * It implements default versions of some methods, 
 * such as getInspector, setSelected, getInspector.
 * 
 * It defines <code>overallT</code>, a Transform3D object that
 * allows the user to handle aspects inside the scene graph,
 * for instance, set the size of an object displayed inside a field, 
 * when size is not relevant for the simulation per se.
 **/
public abstract class FieldPortrayal3D extends FieldPortrayal implements Portrayal3D
{
	/**
	 * It defines <code>overallT</code>, a Transform3D object that
	 * allows the user to handle aspects inside the scene graph,
	 * for instance, set the size of an object displayed inside a field, 
	 * when size is not relevant for the simulation per se.
	 * 
	 * It can only be set through the constructor
	 **/
    public final Transform3D overallT;
    
    public FieldPortrayal3D(Transform3D transform)
    {
		if(transform == null)
			//default overall Transform
			overallT = new Transform3D();
		else
			overallT = transform;
    }

	public abstract LocationWrapper completedWrapper(LocationWrapper w,PickIntersection pi);
 	public void setParentPortrayal(FieldPortrayal3D p){}
 	//TODO delete this	
//	public abstract LocationWrapper getWrapper(final Object obj);
}