package sim.portrayal3d;

import sim.portrayal.*;
import javax.media.j3d.*;

/**
 * A PortrayalJ3D is a Portrayal that produces Java3D models.
 */
public interface Portrayal3D extends Portrayal
{
	/**
	 * If argument is null, it should behave like createModel;
	 * otherwise, it is updateModel.
	 * The newly created version or the updated one should be returned.
	 * 
	 * The sub-scene graph repesented by a portrayal is wraped 
	 * in a TransformGroup, so the parent could place the child
	 * at the apropriate position relative to the parent's coordinate system.
	 * 
	 * The child is responsible for positioning itself relative to its own
	 * coordinate system. E.g. if the model assumes the position for an
	 * object is the postion of its center/upper-left corner/etc, then
	 * the portrayal for the object should have the center/upper-left
	 * corner of the J3D model of the object in the origin of its
	 * coorniate system.
	 */
    public TransformGroup getModel(Object object, TransformGroup prev);
    /**
     * A non field portrayal3D need to enclose its parent FieldPortrayal into the PickInfo.
     * A FieldPortrayal3D should have an empty body.
     **/
 	public void setParentPortrayal(FieldPortrayal3D p);
}