package sim.portrayal3d;

import sim.portrayal.*;
import sim.display.*;
import javax.media.j3d.*;
/**
 * @author Gabriel Balan
 * 
 * A useful abstract superclass for objects. 
 * It implements the inspector methods
 *
 * @see sim.portrayal.SimplePortrayal.java
 */
public abstract class SimplePortrayal3D implements Portrayal3D
{
	public Inspector getInspector(LocationWrapper wrapper, GUIState state)
	{
		if (wrapper == null) return null;
		return new SimpleInspector(wrapper.getObject(), state, "Properties");
	}
	
	public String getName(LocationWrapper wrapper)
	{
		if (wrapper == null) return "";
		return "" + wrapper.getObject();
	}

	public void setParentPortrayal(FieldPortrayal3D p){}
	
	// COPIED from SimplePortrayal2D
	public boolean setSelected(LocationWrapper wrapper, boolean selected)
	{
		// by default, we don't want to be selected
		if (selected) return false;  // don't want to be selected
		else return true;            // we'll always be deselected -- doesn't matter
	}
	
	public static void setPickableFlags(Shape3D s3d)
	{
		s3d.setCapability(Shape3D.ALLOW_GEOMETRY_READ);
		setPickableFlags(s3d.getGeometry());
	}
	public static void setPickableFlags(Geometry geom)
	{
		geom.setCapability(GeometryArray.ALLOW_COUNT_READ);
		geom.setCapability(GeometryArray.ALLOW_FORMAT_READ);
		geom.setCapability(GeometryArray.ALLOW_COORDINATE_READ);
	}
	static public void clearPickableFlags(Node n)
	{
		n.setPickable(false);
		n.clearCapability(Group.ENABLE_PICK_REPORTING);
	}
}
