package sim.portrayal3d.continuous;

import javax.vecmath.*;
import javax.media.j3d.*;
import sim.portrayal.*;
import sim.portrayal3d.*;
import sim.util.*;
import sim.field.continuous.*;

import com.sun.j3d.utils.picking.*;
/**
 * portrayal 3D for Continuous3Ds and Continuous2Ds.
 * @author Gabriel Balan
 */
public class Continuous3DPortrayal extends SparseFieldPortrayal3D
{
	public Continuous3DPortrayal(Continuous3D field, double dx, double dy, double dz)
	{
		super(field, 0, 0, 0, dx, dy, dz);
	}
	public Continuous3DPortrayal(Continuous2D field, double dx, double dy, double dz)
	{
		super(field, 0, 0, 0, dx, dy, dz);
	}
	public Continuous3DPortrayal(Continuous3D field, double x, double y, double z, double dx, double dy, double dz)
	{
		super(field, x, y, z, dx, dy, dz);
	}
	public Continuous3DPortrayal(Continuous2D field, double x, double y, double z, double dx, double dy, double dz)
	{
		super(field, x, y, z, dx, dy, dz);
	}
	
	public Continuous3DPortrayal(Continuous2D field, Transform3D transf)
	{
		super(field, transf);
	}
	public Continuous3DPortrayal(Continuous3D field, Transform3D transf)
	{
		super(field, transf);
	}

	/**
	 * @see sim.portrayal.SparseFieldPortrayal3D#getLocationOfObjectAsVector3d(Object)
	 */
	public Vector3d getLocationOfObjectAsVector3d(Object obj)
	{
		if(field instanceof Continuous2D)
		{
			Double2D locationD2d = ((Continuous2D)field).getObjectLocation(obj);
			tmpVect.x = locationD2d.x;
			tmpVect.y = locationD2d.y;
			tmpVect.z = 0;
		}
		else
		{
			Double3D locationD3d = ((Continuous3D)field).getObjectLocation(obj);
			tmpVect.x = locationD3d.x;
			tmpVect.y = locationD3d.y;
			tmpVect.z = locationD3d.z;
		}
		return tmpVect;
	}

	public void setField(Object field)
	{
		if (field instanceof Continuous3D) this.field = (Continuous3D) field;
		else throw new RuntimeException("Invalid field for Continuous3DPortrayal3D: " + field);
	}	
	public Object getField()
	{
		return field;
	}
	
	public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi)
	{
		return new LocationWrapper( w.getObject(),null, this)  // don't care about location
		{
			public Object getLocation()
			{
				if(field instanceof Continuous3D)
					return ((Continuous3D)field).getObjectLocation(object);
				else
					return ((Continuous2D)field).getObjectLocation(object);
			}
                
			public String getLocationName()
			{
				if(field instanceof Continuous3D)
					return ((Continuous3D)field).getObjectLocation(object).toCoordinates();
				else
					return ((Continuous2D)field).getObjectLocation(object).toCoordinates();
			}
		};
	}	

}
