package sim.portrayal3d.grid;
import sim.field.grid.*;

/**
 * @author Catalin Gabriel Balan
 * The gridPortrayal will pass an object of this kind
 * to the GridCellPortrayal. To accomodate wire-frame meshes
 * a GridCellPortrayal must know more than the value in a certain point, 
 * it must know the value in neighboring points, too.
 */
public class GridCellInfo {
	/** This could be Grid2D or Grid3D */
	final public Grid grid;
	/** this is equivalent to grid instanceof Grid3D, but cached */
	final public boolean is3D;
	public int x = 0;
	public int y = 0;
	public int z = 0;
	
	public GridCellInfo(Grid2D g)
	{
		if(g instanceof IntGrid2D)
			grid = new IntGrid2DW((IntGrid2D)g);
		else
			grid = new DoubleGrid2DW((DoubleGrid2D)g);
		is3D = false;
	} 
	
	public GridCellInfo(Grid3D g)
	{
		if(g instanceof IntGrid3D)
			grid = new IntGrid3DW((IntGrid3D)g);
		else
			grid = new DoubleGrid3DW((DoubleGrid3D)g);
		is3D = true;
	} 

	public double value(){return grid.value(x,y,z);}
	
	/** Interface all grids should implement.
	 * Until that happens, each grid get a 
	 * wrapper that implements it
	 */
	public interface Grid {public double value(int x, int y, int z);}
	public class IntGrid2DW implements Grid
	{
		IntGrid2D ig2;
		public IntGrid2DW(IntGrid2D g){ ig2 = g;}
		public double value(int x, int y, int z){return ig2.field[x][y];}
	}
	public class DoubleGrid2DW implements Grid
	{
		DoubleGrid2D dg2;
		public DoubleGrid2DW(DoubleGrid2D g){ dg2 = g;}
		public double value(int x, int y, int z){return dg2.field[x][y];}
	}
	public class IntGrid3DW implements Grid
	{
		IntGrid3D ig3;
		public IntGrid3DW(IntGrid3D g){ ig3 = g;}
		public double value(int x, int y, int z){return ig3.field[x][y][z];}
	}
	public class DoubleGrid3DW implements Grid
	{
		DoubleGrid3D dg3;
		public DoubleGrid3DW(DoubleGrid3D g){ dg3 = g;}
		public double value(int x, int y, int z){return dg3.field[x][y][z];}
	}
}
