package sim.portrayal3d.grid;
import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * @author Gabriel Catalin Balan
 * 
 * Use this as default tranform for grid based FieldPotrayal3Ds
 * This is a version of DefaultTransform customized for grids:
 * 
 * The (i,j[,k]) locations repesent the center of the grid cells,
 * and the center of the grid is in the origin.
 * 
 * @see sim.portrayal.GridDefaultTransform 
 **/
public class GridDefaultTransform
{
	static public Transform3D getDefaultGrid3DTransform(double width, double height, double length, double scale) 
	{
		Transform3D centerT = new Transform3D();
		double scaleFactor = scale/Math.max(height, Math.max(width,length));
		centerT.setTranslation(new Vector3d(-0.5*scaleFactor*(width-1), 
											-0.5*scaleFactor*(height-1),
											-0.5*scaleFactor*(length-1)));
		centerT.setScale(scaleFactor);
		return centerT;
	}
	static public Transform3D getDefaultGrid3DTransform(double width, double height, double length) 
	{
		return getDefaultGrid3DTransform(width, height, length, 1);
	}
	static public Transform3D getDefaultGrid2DTransform(double width, double height, double scale) 
	{
		return getDefaultGrid3DTransform(width, height, 1, scale);
	}
	static public Transform3D getDefaultGrid2DTransform(double width, double height) 
	{
		return getDefaultGrid3DTransform(width, height, 1, 1);
	}
}
