package sim.portrayal3d.grid;

import javax.vecmath.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.picking.*;
import sim.portrayal.*;
import sim.field.*;
import sim.field.grid.*;
import sim.portrayal3d.*;
import sim.util.*;
/**
 * portrayal 3D for SparseFields.
 * 
 * @author Gabriel Balan
 */
public class SparseGrid3DPortrayal extends SparseFieldPortrayal3D
{

	public SparseGrid3DPortrayal(SparseGrid2D field, double dx, double dy)
	{
		super(field, GridDefaultTransform.getDefaultGrid2DTransform(dx, dy, 1));
	}
	public SparseGrid3DPortrayal(SparseGrid3D field, double dx, double dy, double dz)
	{
		super(field, GridDefaultTransform.getDefaultGrid2DTransform(dx, dy, dz));
	}

	public SparseGrid3DPortrayal(SparseGrid2D field, Transform3D transf)
	{
		super(field, transf);
	}
	public SparseGrid3DPortrayal(SparseGrid3D field, Transform3D transf)
	{
		super(field, transf);
	}

	/**
	 * @see sim.portrayal.SparseFieldPortrayal3D#getLocationOfObjectAsVector3d(Object)
	 */
	public Vector3d getLocationOfObjectAsVector3d(Object obj)
	{
		if(field instanceof SparseGrid3D)
		{
			Int3D locationI3d = ((SparseGrid3D)field).getObjectLocation(obj);
			tmpVect.x = locationI3d.x;
			tmpVect.y = locationI3d.y;
			tmpVect.z = locationI3d.z;
		}
		else
		{
			Int2D locationI2d = ((SparseGrid2D)field).getObjectLocation(obj);
			tmpVect.x = locationI2d.x;
			tmpVect.y = locationI2d.y;
			tmpVect.z = 0;
		}
		return tmpVect;
	}

	public void setField(Object field)
	{
		if (field instanceof SparseField) this.field = (SparseField) field;
		else throw new RuntimeException("Invalid field for SparseGrid3DPortrayal3D: " + field);
	}
        
	public Object getField()
	{
		return field;
	}
	
	public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi)	
	{
		return new LocationWrapper( w.getObject(), null , this)  // don't care about location
		{
			public Object getLocation()
			{
				if(field instanceof SparseGrid3D)
					return ((SparseGrid3D)field).getObjectLocation(object);
				else
					return ((SparseGrid2D)field).getObjectLocation(object);
			}
                
			public String getLocationName()
			{
				if(field instanceof SparseGrid3D)
					return ((SparseGrid3D)field).getObjectLocation(object).toCoordinates();
				else
					return ((SparseGrid2D)field).getObjectLocation(object).toCoordinates();
			}
		};
	}

}
