package sim.portrayal3d.grid;

import sim.field.grid.*;
import sim.portrayal.*;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.fastgridcell.*;
import sim.util.*;

import javax.vecmath.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.picking.*;
/**
 * @author Gabriel Balan
 * 
 */
public class ValueGrid2D3DPortrayal extends FieldPortrayal3D implements ConfigurablePolyPortrayal
{
	public Grid2D field;
	
	public ValueGrid2D3DPortrayal(Grid2D grid, double width, double height)
	{
		super(GridDefaultTransform.getDefaultGrid2DTransform(width, height));
		setField(grid);
	}
	
	public ValueGrid2D3DPortrayal(Grid2D grid,Transform3D transf)
	{	
		super(transf);
		setField(grid);
	}
	
    
	public Object getField()
	{
		return field;
	}

	public String valueName = "Value in the grid";
	private PolygonAttributes mPolyAttributes = new PolygonAttributes(); 
	{
		mPolyAttributes.setCapability(PolygonAttributes.ALLOW_CULL_FACE_WRITE);
		mPolyAttributes.setCapability(PolygonAttributes.ALLOW_MODE_WRITE);
		mPolyAttributes.clearCapabilityIsFrequent(PolygonAttributes.ALLOW_CULL_FACE_WRITE);
		mPolyAttributes.clearCapabilityIsFrequent(PolygonAttributes.ALLOW_MODE_WRITE);
	}  
	

	public PolygonAttributes getPolyAttributes()
	{
		return mPolyAttributes;
	}
	
	float[] coords;
	float[] colors;
	
	
	public void setField(Object grid)
	{
		if(this.field == grid)
			return;
		if (grid instanceof Grid2D) 
		    this.field = (Grid2D) grid;
		else throw new RuntimeException("ValueGrid2DPortrayal3D cannot portray the object: " + grid);
		tmpGCI = new GridCellInfo(this.field);
		coords = new float[field.getWidth()* field.getHeight()*4*3];
		colors = new float[field.getWidth()* field.getHeight()*4*3];
	}
	

	// TODO put something here 
	static Portrayal3D defaultPortrayal = null;	
	public Portrayal getDefaultPortrayal()
	{
		return defaultPortrayal;
	}
	
	
	/** tmp Vector3d */ 
	protected Vector3d tmpVect = new Vector3d();
	/** tmp Transform3D 
	 * it is reused, since the TGs are copying it internally*/
	protected Transform3D tmpLocalT = new Transform3D();

	/** allocated in portray, and heavily reused in create/update model
	 * to avoid "new"s
	 */
	private GridCellInfo tmpGCI;


	/**
	 * Create J3D subgraphs for all objects in the field
	 * note that each subgraph points to the simulation
	 * object it represents, for update purposes.
	 **/
	public TransformGroup createModel()
	{	
		GridCellQuadPortrayal quadPortrayal = (GridCellQuadPortrayal)getPortrayalForObject(tmpGCI);
		
		TransformGroup modelTG = new TransformGroup();
		modelTG.setTransform(overallT);
		
		QuadArray qa;
		qa = new QuadArray(4*field.getWidth()*field.getHeight(), QuadArray.COORDINATES | QuadArray.COLOR_3);
		qa.setCapability(QuadArray.ALLOW_COLOR_WRITE);
		qa.setCapability(QuadArray.ALLOW_COORDINATE_WRITE);
		SimplePortrayal3D.setPickableFlags(qa);
		
		tmpVect.z = 0;
		int quadIndex = 0;
		for(int i=0; i<field.getWidth();i++)
		{		
			tmpGCI.x = i;
			
			// cell<i,j> is i units to far on x and j unit too far on y.
			//
			tmpVect.x = i;
			for(int j=0; j<field.getHeight();j++)
			{
				tmpGCI.y = j;
				tmpVect.y = j;
//				quadPortrayal.setQuad(tmpGCI, qa,quadIndex);
				quadPortrayal.setData(tmpGCI, coords, colors, quadIndex);
				quadIndex++;
			}
		}
		qa.setCoordinates(0, coords);
		qa.setColors(0,colors);
		
		Shape3D shape = new Shape3D(qa);
		shape.setCapability(Shape3D.ALLOW_GEOMETRY_READ);

		Appearance ap = new Appearance();
		ap.setPolygonAttributes(mPolyAttributes);
		shape.setAppearance(ap);


		LocationWrapper pi = new LocationWrapper(null, null, this);
		shape.setUserData(pi);

		modelTG.addChild(shape);
		modelTG.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		return modelTG;

	}

	public TransformGroup getModel(Object obj, TransformGroup modelTG)
	{
		if(modelTG == null)
			return createModel();
		GridCellQuadPortrayal quadPortrayal = (GridCellQuadPortrayal)getPortrayalForObject(tmpGCI);			
		Shape3D shape = (Shape3D)modelTG.getChild(0);
		QuadArray qa = (QuadArray)shape.getGeometry();
		int quadIndex = 0;
		for(int i=0; i<field.getWidth();i++)
		{		
			tmpGCI.x = i;
			for(int j=0; j<field.getHeight();j++)
			{
				tmpGCI.y = j;
//				quadPortrayal.setQuad(tmpGCI, qa,quadIndex);
				quadPortrayal.setData(tmpGCI, coords, colors, quadIndex);
				quadIndex++;
			}
		}
		qa.setCoordinates(0, coords);
		qa.setColors(0,colors);
		return modelTG;
	}
	
//	public String getName(Object object)
//	{
//		return valueName + " {" + 
//				tmpGCI.x + ", " + 
//				tmpGCI.y + 
//				(tmpGCI.is3D? ", "+ tmpGCI.z : "")+
//				"}";
//	}	

	public String getName(LocationWrapper wrapper)
	{
		return valueName +" at "+wrapper.getLocationName();
	}

	public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi)
	{
		
		int[] indices = pi.getPrimitiveVertexIndices();
		if(indices == null)
			return null;

		int height = field.getHeight();
		int x = indices[0]/4/height;
		int y = indices[0]/4%height;

		return new LocationWrapper( new GridCellInfo(field), new Int2D(x, y), this ) 
		{
			public Object getObject(){return new MutableDouble(((GridCellInfo)object).value());}
			public String getLocationName()
			{
				return ((Int2D)location).toCoordinates();
			}
		};
	}
}
