package sim.portrayal3d.grid.fastgridcell;

import sim.display.*;
import sim.portrayal.*;
import sim.portrayal3d.grid.*;
//import javax.media.j3d.*;
/**
 * @author Gabriel Balan
 *
 *	This is not PortrayalJ3D. It does not create a piece of 
 * 3D-scene model, it is in charge with a specific piece of
 * a piece of a 3D-scene model: it handles a quad in a
 * QuadArray 
 */
public abstract class GridCellQuadPortrayal implements Portrayal {
	public abstract void setData(GridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex);
	
	public String getName(LocationWrapper wrapper){
		return "grid cell";
	}
	public boolean setSelected(LocationWrapper wrapper, boolean selected)
	{
		// by default, we don't want to be selected
		if (selected) return false;  // don't want to be selected
		else return true;            // we'll always be deselected -- doesn't matter
	}
    
	public Inspector getInspector(LocationWrapper wrapper, GUIState state)
	{
		if (wrapper == null) return null;
		return new SimpleInspector(wrapper.getObject(), state, "Properties");
	}
}
