package sim.portrayal3d.grid.fastgridcell;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;
//import sim.field.grid.*;
//import javax.media.j3d.*;
/**
 * @author Catalin
 *
 * NOTE: this is building a square around a grid cell (like Tile... does)
 * this builds a quad around four grid cells.
 * 
 * Therefore, you will get a (A-1)x(B-1) grid of quads for a AxB Grid2D 
 **/
public class MeshCellPortrayal extends GridCellQuadPortrayal
{
	public float[] tmpCoords;
	public float[] tmpColor;
	private int colorComponents;
	private ColorCoding colorDispenser;
	private int width;
	private int height;
	public MeshCellPortrayal(int colorComponents, ColorCoding colorDispenser, int width, int height)
	{
		this.colorDispenser = colorDispenser;
		this.colorComponents = colorComponents;
		this.width = width-1;//!!! i have a quad between grid cells
		this.height = height-1;//!!!
		tmpCoords = new float[12];
		tmpColor = new float[4]; //just in case awt.Color.getColorComponents wants 4 spaces.
	}
	static int[] dx = {0, -1, -1, 0};
	static int[] dy = {0, 0, -1, -1};
	
	public void setData(GridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex)
	{
		int x = gridCell.x;
		int y = gridCell.y;
		float value = (float)gridCell.value();
		colorDispenser.getColor(value).getColorComponents(tmpColor);
		value /=2000; //scale value
//		3-2
//		| |  <- this is how I go through a quad.
//		0-1
//
//		3-2 3-2
//		| | | |
//		0-1 0-1
//	    3-2 3-2
//		| | | |
//		0-1 0-1
		//look for the four quads this vertex is part of.
		for(int i=0; i<4; i++)
		{
			int cellx = x+dx[i];
			int celly = y+dy[i];
			if(cellx<0 || celly<0 || cellx>=width || celly>=height)
				continue;
			int iQuadIndex = cellx*width+celly;
			int offset = iQuadIndex * 12 + i * 3;
			
			coordinates[offset+0] = x;
			coordinates[offset+1] = y;
			coordinates[offset+2] = value;
			System.arraycopy(tmpColor, 0, colors, (iQuadIndex*4+i)*colorComponents, colorComponents);
		}
	}

}
