package sim.portrayal3d.grid.fastgridcell;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;

/**
 * @author Catalin Gabriel Balan
 *
 */
public class NoZGridCellPortrayal extends TileGridCellPortrayal
{
	public NoZGridCellPortrayal(int colorComponents, ColorCoding colorDispenser)
	{
		super(colorComponents, colorDispenser);
	}
	
	public void setData(GridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex)
	{
		int x = gridCell.x;
		int y = gridCell.y;
		float value = (float)gridCell.value();
		colorDispenser.getColor(value).getColorComponents(tmpColor);
		for(int i=0;i <4;i++) 
		System.arraycopy(tmpColor, 0, colors, (quadIndex*4+i)*colorComponents, colorComponents);

		int offset = quadIndex*12; 
		coordinates[offset+0] = x - 0.5f;
		coordinates[offset+1] = y- 0.5f;
		coordinates[offset+2] = 0;
		coordinates[offset+3] = x + 0.5f;
		coordinates[offset+4] = y - 0.5f;
		coordinates[offset+5] = 0;
		coordinates[offset+6] = x + 0.5f;
		coordinates[offset+7] = y + 0.5f;
		coordinates[offset+8] = 0;
		coordinates[offset+9] = x - 0.5f;
		coordinates[offset+10]= y + 0.5f;
		coordinates[offset+11]= 0;
	}

}
