package sim.portrayal3d.grid.fastgridcell;
import sim.portrayal3d.*;
import sim.portrayal3d.grid.*;
//import javax.media.j3d.*;

/**
 * @author Catalin Gabriel Balan
 *
 */
public class TileGridCellPortrayal extends GridCellQuadPortrayal
{
	public float[] tmpCoords;
	public float[] tmpColor;
	protected int colorComponents;
	protected ColorCoding colorDispenser;
	
	public TileGridCellPortrayal(int colorComponents, ColorCoding colorDispenser)
	{
		this.colorDispenser = colorDispenser;
		this.colorComponents = colorComponents;
		
		tmpCoords = new float[12];
		tmpColor = new float[4]; //just in case awt.Color.getColorComponents wants 4 spaces.
	}
	

//	public void setQuad(GridCellInfo gridCell, QuadArray qa, int quadIndex)
//	{
//		
//		int x = gridCell.x;
//		int y = gridCell.y;
//
//		if(x==0 && y==0)
//			iteration++;
//		if(iteration==1)
//		{
//		tmpCoords[0] = x - 0.5f;
//		tmpCoords[1] = y- 0.5f;
//		tmpCoords[2] = 0;
//		tmpCoords[3] = x + 0.5f;
//		tmpCoords[4] = y - 0.5f;
//		tmpCoords[5] = 0;
//		tmpCoords[6] = x + 0.5f;
//		tmpCoords[7] = y + 0.5f;
//		tmpCoords[8] = 0;
//		tmpCoords[9] = x - 0.5f;
//		tmpCoords[10]= y + 0.5f;
//		tmpCoords[11]= 0;
//		qa.setCoordinates(quadIndex*4, tmpCoords);
//		}
//		
//		float value = (float)gridCell.value();
//		colorDispenser.getColor(value).getColorComponents(tmpColor); 
//		
//		for(int i= 0;i<4;i++)
//			qa.setColor((quadIndex*4+i), tmpColor);
//	}
//	
	public void setData(GridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex)
	{
		int x = gridCell.x;
		int y = gridCell.y;
		float value = (float)gridCell.value();
		colorDispenser.getColor(value).getColorComponents(tmpColor);
		for(int i=0;i <4;i++) 
		System.arraycopy(tmpColor, 0, colors, (quadIndex*4+i)*colorComponents, colorComponents);

		int offset = quadIndex*12; 
		coordinates[offset+0] = x - 0.5f;
		coordinates[offset+1] = y- 0.5f;
		coordinates[offset+2] = value/2000;
		coordinates[offset+3] = x + 0.5f;
		coordinates[offset+4] = y - 0.5f;
		coordinates[offset+5] = value/2000;
		coordinates[offset+6] = x + 0.5f;
		coordinates[offset+7] = y + 0.5f;
		coordinates[offset+8] = value/2000;
		coordinates[offset+9] = x - 0.5f;
		coordinates[offset+10]= y + 0.5f;
		coordinates[offset+11]= value/2000;

	}

}
