package sim.portrayal3d.simple;

import sim.portrayal3d.*;
import javax.media.j3d.*;

/**
 * White cube of size 1, centered in the origin, perfect for a default portrayal.
 * 
 * 
 * Portions of this software is based on the file ColorCube.java, available
 * as part of the Java3D Developer Kit examples, and falls under the license
 * that came with that example.  The license is listed at the end of this file.
 * The remainder of the file falls under the standard license for this library.
 * */
public class CubePortrayal3D extends SimplePortrayal3D
{
    static SharedGroup cubeModel = null;
    static 
    {
		QuadArray cubeGeometry = new QuadArray(24, QuadArray.COORDINATES);
		float[] verts = 
		{
		 0.5f, -0.5f,  0.5f,	 0.5f,  0.5f,  0.5f,	-0.5f,  0.5f,  0.5f,	-0.5f, -0.5f,  0.5f,/* front face*/	
		-0.5f, -0.5f, -0.5f,	-0.5f,  0.5f, -0.5f,	 0.5f,  0.5f, -0.5f,	 0.5f, -0.5f, -0.5f,/* back face*/	
		 0.5f, -0.5f, -0.5f,	 0.5f,  0.5f, -0.5f,	 0.5f,  0.5f,  0.5f,	 0.5f, -0.5f,  0.5f,/* right face*/	
		-0.5f, -0.5f,  0.5f,	-0.5f,  0.5f,  0.5f,	-0.5f,  0.5f, -0.5f,	-0.5f, -0.5f, -0.5f,/* left face*/	
		 0.5f,  0.5f,  0.5f,	 0.5f,  0.5f, -0.5f,	-0.5f,  0.5f, -0.5f,	-0.5f,  0.5f,  0.5f,/* top face*/	
		-0.5f, -0.5f,  0.5f,	-0.5f, -0.5f, -0.5f,	 0.5f, -0.5f, -0.5f,	 0.5f, -0.5f,  0.5f/* bottom face*/
	    };
		cubeGeometry.setCoordinates(0, verts);

    	Appearance appearance = new Appearance();
    	appearance.setColoringAttributes(new ColoringAttributes( 1f, 1f, 1f, ColoringAttributes.SHADE_FLAT));		
		Shape3D cubeShape = new Shape3D(cubeGeometry, appearance);

    	cubeModel = new SharedGroup();
    	cubeModel.addChild(cubeShape);
    	cubeModel.compile();
    }
    
	public CubePortrayal3D(){}


	public TransformGroup getModel(Object obj, TransformGroup j3dModel)
	{
		if(j3dModel==null)
		{
			j3dModel = new TransformGroup();
			j3dModel.addChild(new Link(cubeModel));
		}
		return j3dModel;
	}
}
/* Portions of this software is based on the file ColorCube.java, available
 * as part of the Java3D Developer Kit examples.  The license for ColorCube.java
 * is listed below.
 *
 *
 *      @(#)ColorCube.java 1.3 98/09/28 13:12:26 
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */