package sim.portrayal3d.simple;

import sim.portrayal3d.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.Sphere;

/**
 * @see com.sun.j3d.utils.geometry.Sphere
 * */
public class SpherePortrayal3D extends SimplePortrayal3D
{
	float radius = 1f;
	Color3f color;
	static Sphere sphere;
	static 
	{
		sphere = new Sphere(1f, 0, 2);
		setPickableFlags(sphere.getShape());		
	}
	
	public SpherePortrayal3D(Color3f c)
	{
		color = c; 
	}
	public SpherePortrayal3D(Color3f c, float radius)
	{
		color = c; this.radius = radius;  
	}


	public TransformGroup getModel(Object obj, TransformGroup j3dModel)
	{
		if(j3dModel==null)
		{
			j3dModel = new TransformGroup();
			Appearance ap = new Appearance();
			ap.setColoringAttributes(new ColoringAttributes(color,ColoringAttributes.SHADE_FLAT));
			Sphere s = (Sphere)(sphere.cloneTree());		
			s.setAppearance(ap);
			
			if(radius == 1f)
				j3dModel.addChild(s);
			else
			{
				Transform3D scaleT = new Transform3D();
				scaleT.setScale(radius);
				j3dModel.addChild(new TransformGroup(scaleT));
			}
		}
		return j3dModel;
	}

}