package sim.util;
import java.util.*;
import java.lang.reflect.*;

public class CollectionProperties extends Properties
    {
    Collection collection;
    Map map;
    Indexed indexed;
    boolean isVolatile;
    
    public CollectionProperties(Collection c)
        {
        isVolatile = true;
        collection = c;
        }
    
    public CollectionProperties(final List list)
        {
        isVolatile = true;
        indexed = new Indexed()
            {
            public Class componentType() { return null; }
            public int size() { return list.size(); }
            public Object set(int index, Object value) { return list.set(index,value); }
            public Object getValue(int index) { return list.get(index); }
            };
        }

    public CollectionProperties(Map m)
        {
        isVolatile = true;
        map = m;
        }
    
    public CollectionProperties(Indexed i)
        {
        isVolatile = true;
        indexed = i;
        }
    
    public boolean isVolatile()
        {
        return isVolatile;
        }

    /** For arrays */
    public CollectionProperties(final Object o) // for arrays
        {
        isVolatile = false;  // fixed in size and order
        
        if ( o == null ) throw new NullPointerException();

        if(!o.getClass().isArray()) 
          throw new IllegalArgumentException("first argument must be of type array.");

        indexed = new Indexed()
            {
            public Class componentType() { return o.getClass().getComponentType(); }
            public int size() { return Array.getLength(o); }
            public Object set(int index, Object value)
                {
                Object oldVal = getValue(index);
                Array.set(o,index,value);
                return oldVal;
                }
            public Object getValue(int index) { return Array.get(o,index); }
            };
        }
    
    public int numProperties()
        {
        if (indexed!=null) return indexed.size();
        else if (collection!=null) return collection.size();
        else return map.size();
        }

    // only for maps and collections
    Iterator valueIterator()
        {
        if (collection !=null) return collection.iterator();
        else
            {
            Set s = map.entrySet();
            final Iterator i = s.iterator();
            return new Iterator()
                {
                public boolean hasNext() { return i.hasNext(); }
                public Object next() { return ((Map.Entry)(i.next())).getValue(); }
                public void remove() { throw new UnsupportedOperationException(
                    "Cannot remove from a CollectionProperties Iterator"); }
                };
            }
        }

    public Object getValue(int index)
        {
        if (index < 0 || index > numProperties()) return null;

        if (indexed!=null) return indexed.getValue(index);  // O(1)
        else  // O(n)
            {
            Iterator i = valueIterator();
            Object obj = null;
            for(int x=0;x<=index;x++)  // yes, it's <=
                {
                if (!i.hasNext()) return null;
                obj = i.next();
                }
            return obj;
            }
        }

    public boolean isReadWrite(int index)
        {
        if (index < 0 || index > numProperties()) return false;

        if (collection!=null) return false;  // collections are not modifiable -- they can't be referenced

        Class type = getTypeConversion(getType(index));
        Object obj = getValue(index);
        if (obj!=null)
            {
            if (!type.isAssignableFrom(obj.getClass())) // uh oh, violated base type
            return false;
            }
        return !isComposite(index);
        }

    public String getName(int index)
        {
        if (index < 0 || index > numProperties()) return null;
        
        if (map!=null)
            {
            Iterator i = map.entrySet().iterator();
            Object obj = null;
            for(int x=0;x<=index;x++)  // yes, it's <=
                {
                if (!i.hasNext()) return null;
                obj = i.next();
                }
            return "" + ((Map.Entry)(obj)).getKey();
            }
        else if (collection!= null)
            {
            return "Member";
            }
        else
            {
            return "" + index;
            }
        }

    public Class getType(int index)
        {
        if (index < 0 || index > numProperties()) return null;
        if (indexed!=null)
            {
            Class type = indexed.componentType();
            if (type!=null) return type;
            }
        Object obj = getValue(index);
        if (obj==null) return Object.class;
        return obj.getClass();
        }

    Object _setValue(int index, Object value)
        {
        if (index < 0 || index > numProperties()) return null;

        if (indexed!=null) indexed.set(index,value);  // O(1)
        else if (map!=null)
            {
            Iterator i = map.entrySet().iterator();
            Object obj = null;
            for(int x=0;x<=index;x++)  // yes, it's <=
                {
                if (!i.hasNext()) return null;
                obj = i.next();
                }
            map.put(((Map.Entry)(obj)).getKey(), value);
            }
        // can't set collections
        return getValue(index);
        }

    }