package sim.app.lsystem;
import sim.engine.*;
import sim.field.continuous.*;
import ec.util.*;
import java.io.*;

public /*strictfp*/ class Lsystem extends SimState
    {
    /** @todo handle realocation of grids when these two are changed */
    public double xMin = 0;
    public double xMax = 100;
    public double yMin = 0;
    public double yMax = 100;
    
    public Lsys l = new Lsys();
    
    public Continuous2D drawEnvironment;
    

    public Lsystem(long seed)
        {
        this(seed, 100, 100);
        }
        
    public Lsystem(long seed, int width, int height)
        {
        super(new MersenneTwisterFast(seed), new Schedule(2));
        xMax = width; yMax = height;
        
        createGrids();
        }

    void createGrids()
        {       
        drawEnvironment = new Continuous2D(5, (xMax - xMin), (yMax - yMin));
        }
    
    /** Resets and starts a simulation */
    public void start()
        {
        super.start();  // clear out the schedule
        createGrids();

        LsysDrawer ld = new LsysDrawer(l);
        ld.stopper = schedule.scheduleRepeating(ld);
        }
    
    public static void main(String[] args)
        {
        doLoop(Lsystem.class, args);
        System.exit(0);
        }    
    }
    
    
    
    
    
