/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.antsforage.AntsForage;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class AntsForageWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D homePheromonePortrayal = new FastValueGridPortrayal2D("Home Pheromone");
    FastValueGridPortrayal2D foodPheromonePortrayal = new FastValueGridPortrayal2D("Food Pheromone");
    FastValueGridPortrayal2D sitesPortrayal = new FastValueGridPortrayal2D("Site", true);
    FastValueGridPortrayal2D obstaclesPortrayal = new FastValueGridPortrayal2D("Obstacle", true);
    SparseGridPortrayal2D bugPortrayal = new SparseGridPortrayal2D();

    public static void main(String[] args) {
        new AntsForageWithUI().createController();
    }

    public AntsForageWithUI() {
        super(new AntsForage(System.currentTimeMillis()));
    }

    public AntsForageWithUI(SimState state) {
        super(state);
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public static String getName() {
        return "Ant Foraging";
    }

    public void setupPortrayals() {
        AntsForage af = (AntsForage)this.state;
        this.homePheromonePortrayal.setField(af.toHomeGrid);
        this.homePheromonePortrayal.setMap(new SimpleColorMap(0.0, 3.0, Color.white, new Color(0, 255, 0, 255)){

            public double filterLevel(double level) {
                return Math.sqrt(Math.sqrt(level));
            }
        });
        this.foodPheromonePortrayal.setField(af.toFoodGrid);
        this.foodPheromonePortrayal.setMap(new SimpleColorMap(0.0, 3.0, new Color(0, 0, 255, 0), new Color(0, 0, 255, 255)){

            public double filterLevel(double level) {
                return Math.sqrt(Math.sqrt(level));
            }
        });
        this.sitesPortrayal.setField(af.sites);
        this.sitesPortrayal.setMap(new SimpleColorMap(0.0, 1.0, new Color(0, 0, 0, 0), new Color(255, 0, 0, 255)));
        this.obstaclesPortrayal.setField(af.obstacles);
        this.obstaclesPortrayal.setMap(new SimpleColorMap(0.0, 1.0, new Color(0, 0, 0, 0), new Color(128, 64, 64, 255)));
        this.bugPortrayal.setField(af.buggrid);
        this.display.reset();
        this.display.repaint();
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.homePheromonePortrayal, "Pheromones To Home");
        this.display.attach(this.foodPheromonePortrayal, "Pheromones To Food");
        this.display.attach(this.sitesPortrayal, "Site Locations");
        this.display.attach(this.obstaclesPortrayal, "Obstacles");
        this.display.attach(this.bugPortrayal, "Agents");
        this.display.setBackdrop(Color.white);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

