/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Element;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Asteroid
extends Element {
    public int size;
    public static final double INITIAL_VELOCITY = 0.3;
    public static final double MAXIMUM_ROTATIONAL_VELOCITY = Math.PI / 180;
    public static final int MAXIMUM_SIZE = 4;
    public static final double MAXIMUM_EXPLOSION_FORCE = 1.0;
    public static final double MINIMUM_EXPLOSION_FORCE = 0.5;
    static final Shape[][] shapes = new Shape[][]{{new Rectangle2D.Double(-3.0, -3.0, 5.0, 5.0)}, {new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0)}, {new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0)}, {new Rectangle2D.Double(-4.0, -4.0, 9.0, 9.0)}, {new Rectangle2D.Double(-5.0, -5.0, 10.0, 10.0)}};
    static final int[][][] breakMap = new int[][][]{new int[][]{new int[0]}, new int[][]{{0, 0}}, new int[][]{{0, 1}, {0, 0, 0}}, new int[][]{{0, 0, 1}, {0, 2}, {1, 1}}, new int[][]{{1, 2}, {0, 3}, {0, 1, 1}}};

    public Asteroid(Asteroids asteroids, int size, MutableDouble2D velocity, Double2D location) {
        this.size = size;
        this.velocity = velocity;
        this.stopper = asteroids.schedule.scheduleRepeating(this);
        this.shape = shapes[size][asteroids.random.nextInt(shapes[size].length)];
        this.rotationalVelocity = asteroids.random.nextDouble() * (Math.PI / 180) * (asteroids.random.nextBoolean() ? 1.0 : -1.0);
        this.orientation = asteroids.random.nextDouble() * Math.PI * 2.0;
        asteroids.field.setObjectLocation((Object)this, location);
        ++asteroids.asteroidCount;
    }

    public void breakApart(final Asteroids asteroids) {
        Double2D location = asteroids.field.getObjectLocation(this);
        int[] sizes = breakMap[this.size][asteroids.random.nextInt(breakMap[this.size].length)];
        if (sizes.length > 0) {
            int sum = 0;
            for (int i = 0; i < sizes.length; ++i) {
                sum += sizes[i];
            }
            double explosionForce = asteroids.random.nextDouble() * 0.5 + 0.5;
            double sumForceX = 0.0;
            double sumForceY = 0.0;
            for (int i = 0; i < sizes.length; ++i) {
                double angle = asteroids.random.nextDouble() * Math.PI * 2.0;
                double force = explosionForce / (double)sizes.length;
                double forceX = force * Math.cos(angle);
                double forceY = force * Math.sin(angle);
                if (i == sizes.length - 1) {
                    forceX = -sumForceX;
                    forceY = -sumForceY;
                } else {
                    sumForceX += forceX;
                    sumForceY += forceY;
                }
                Asteroid a = new Asteroid(asteroids, sizes[i], new MutableDouble2D(this.velocity.x + forceX, this.velocity.y + forceY), location);
            }
        } else {
            this.breakIntoShards(asteroids);
        }
        this.end(asteroids);
        --asteroids.asteroidCount;
        if (asteroids.asteroidCount <= 0) {
            asteroids.schedule.scheduleOnceIn(60.0, new Steppable(){

                public void step(SimState state) {
                    asteroids.createAsteroids();
                }
            });
        }
    }
}

