/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Overlay;
import sim.app.asteroids.RateAdjuster;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.SimpleController;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;

public class AsteroidsWithUI
extends GUIState {
    public double FRAMES_PER_SECOND = 60.0;
    public Display2D display;
    public JFrame displayFrame;
    public ContinuousPortrayal2D fieldPortrayal = new ContinuousPortrayal2D();
    public Overlay overlay = new Overlay(this);

    public static void main(String[] args) {
        new AsteroidsWithUI().createController();
    }

    public Controller createController() {
        SimpleController c = new SimpleController(this);
        c.pressPlay();
        return c;
    }

    public AsteroidsWithUI() {
        super(new Asteroids(System.currentTimeMillis()));
    }

    public AsteroidsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Asteroids";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Asteroids asteroids = (Asteroids)this.state;
        this.fieldPortrayal.setField(asteroids.field);
        this.fieldPortrayal.setDisplayingToroidally(true);
        this.scheduleRepeatingImmediatelyAfter(new RateAdjuster(this.FRAMES_PER_SECOND));
        this.display.reset();
        this.display.repaint();
    }

    public void init(final Controller c) {
        super.init(c);
        this.display = new Display2D(750.0, 750.0, this){

            public void createSimpleControllerMenu() {
            }

            public void quit() {
                super.quit();
                ((SimpleController)c).doClose();
            }
        };
        this.display.setBackdrop(Color.black);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Asteroids");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.fieldPortrayal, "Asteroids");
        this.display.attach(this.overlay, "Overlay");
        this.display.remove(this.display.header);
        this.display.removeListeners();
        JScrollPane cfr_ignored_0 = this.display.display;
        this.display.display.setVerticalScrollBarPolicy(21);
        JScrollPane cfr_ignored_1 = this.display.display;
        this.display.display.setHorizontalScrollBarPolicy(31);
        this.displayFrame.setDefaultCloseOperation(2);
        this.displayFrame.setResizable(false);
        this.display.insideDisplay.setupHints(true, false, false);
        this.displayFrame.pack();
        this.addListeners(this.display);
    }

    public void addListeners(final Display2D display) {
        final Asteroids asteroids = (Asteroids)this.state;
        final SimpleController cont = (SimpleController)this.controller;
        display.setFocusable(true);
        this.displayFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                display.requestFocusInWindow();
            }
        });
        display.requestFocusInWindow();
        display.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int c = e.getKeyCode();
                switch (c) {
                    case 38: {
                        asteroids.actions[0] = asteroids.actions[0] & 0xFFFFFFFD;
                        break;
                    }
                    case 40: {
                        asteroids.actions[0] = asteroids.actions[0] & 0xFFFFFFEF;
                        break;
                    }
                    case 37: {
                        asteroids.actions[0] = asteroids.actions[0] & 0xFFFFFFFE;
                        break;
                    }
                    case 39: {
                        asteroids.actions[0] = asteroids.actions[0] & 0xFFFFFFFB;
                        break;
                    }
                    case 32: {
                        asteroids.actions[0] = asteroids.actions[0] & 0xFFFFFFF7;
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
                int c = e.getKeyCode();
                switch (c) {
                    case 38: {
                        asteroids.actions[0] = asteroids.actions[0] | 2;
                        break;
                    }
                    case 40: {
                        asteroids.actions[0] = asteroids.actions[0] | 0x10;
                        break;
                    }
                    case 37: {
                        asteroids.actions[0] = asteroids.actions[0] | 1;
                        break;
                    }
                    case 39: {
                        asteroids.actions[0] = asteroids.actions[0] | 4;
                        break;
                    }
                    case 32: {
                        asteroids.actions[0] = asteroids.actions[0] | 8;
                        break;
                    }
                    case 82: {
                        cont.pressStop();
                        cont.pressPlay();
                        break;
                    }
                    case 80: {
                        cont.pressPause();
                        break;
                    }
                    case 77: {
                        if (cont.getPlayState() != 2) {
                            cont.pressPause();
                        }
                        cont.doNew();
                        display.requestFocusInWindow();
                    }
                }
            }
        });
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

