/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import sim.app.asteroids.Asteroid;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Element;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Bullet
extends Element {
    public static final double VELOCITY = 1.0;
    public static final int LIFETIME = 100;

    public Bullet(Asteroids asteroids, MutableDouble2D velocity, Double2D location, int lifetime) {
        this.shape = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        this.velocity = velocity;
        this.rotationalVelocity = 0.0;
        this.stopper = asteroids.schedule.scheduleRepeating(this);
        asteroids.field.setObjectLocation((Object)this, location);
        asteroids.schedule.scheduleOnceIn(lifetime, new Steppable(){

            public void step(SimState state) {
                Bullet.this.end((Asteroids)state);
            }
        });
    }

    public void step(SimState state) {
        this.testForHit((Asteroids)state);
        super.step(state);
    }

    public Color getColor() {
        return Color.white;
    }

    public void testForHit(Asteroids asteroids) {
        Bag a = asteroids.field.getAllObjects();
        for (int i = 0; i < a.numObjs; ++i) {
            Asteroid asteroid;
            Object obj = a.objs[i];
            if (!(obj instanceof Asteroid) || !(asteroid = (Asteroid)a.objs[i]).collisionWithElement(asteroids, this)) continue;
            this.end(asteroids);
            asteroid.breakApart(asteroids);
            ++asteroids.score;
            break;
        }
    }
}

