/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Shard;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public abstract class Element
extends SimplePortrayal2D
implements Steppable {
    public Shape shape;
    public double orientation;
    public MutableDouble2D velocity;
    public double rotationalVelocity;
    public Stoppable stopper;

    public Area getLocatedArea(double translateX, double translateY, double scaleX, double scaleY) {
        AffineTransform transform = new AffineTransform();
        transform.translate(translateX, translateY);
        transform.rotate(this.orientation);
        if (scaleX != 1.0 && scaleY != 1.0) {
            transform.scale(scaleX, scaleY);
        }
        Area area = new Area(this.shape);
        area.transform(transform);
        return area;
    }

    public Area getLocatedArea(Asteroids asteroids) {
        Double2D loc = asteroids.field.getObjectLocation(this);
        return this.getLocatedArea(loc.x, loc.y, 1.0, 1.0);
    }

    public boolean collisionWithElement(Asteroids asteroids, Element element) {
        Double2D d = asteroids.field.getObjectLocation(this);
        double width = asteroids.field.width;
        double height = asteroids.field.height;
        Area elementloc = element.getLocatedArea(asteroids);
        Area a = this.getLocatedArea(asteroids);
        a.add(elementloc);
        if (a.isSingular()) {
            return true;
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(d.x < width / 2.0 ? width : 0.0 - width, 0.0);
        a.transform(transform);
        a.add(elementloc);
        if (a.isSingular()) {
            return true;
        }
        a = this.getLocatedArea(asteroids);
        AffineTransform transform2 = new AffineTransform();
        transform2.translate(0.0, d.y < height / 2.0 ? height : 0.0 - height);
        a.transform(transform2);
        a.add(elementloc);
        return a.isSingular();
    }

    public void step(SimState state) {
        Asteroids asteroids = (Asteroids)state;
        this.orientation += this.rotationalVelocity;
        Double2D location = asteroids.field.getObjectLocation(this);
        if (location == null) {
            return;
        }
        asteroids.field.setObjectLocation((Object)this, new Double2D(asteroids.field.stx(location.x + this.velocity.x), asteroids.field.sty(location.y + this.velocity.y)));
    }

    public Color getColor() {
        return Color.blue;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        graphics.setColor(this.getColor());
        graphics.draw(this.getLocatedArea(info.draw.x, info.draw.y, info.draw.width, info.draw.height));
    }

    public void breakIntoShards(Asteroids asteroids) {
        Double2D location = asteroids.field.getObjectLocation(this);
        PathIterator p = new Area(this.shape).getPathIterator(null);
        float[] vals = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstX = 0.0f;
        float firstY = 0.0f;
        float midX = 0.0f;
        float midY = 0.0f;
        Shard shard = null;
        Double2D vec = null;
        while (!p.isDone()) {
            GeneralPath s = new GeneralPath();
            int type = p.currentSegment(vals);
            double force = asteroids.random.nextDouble() * 0.5;
            switch (type) {
                case 0: {
                    lastX = firstX = vals[0];
                    lastY = firstY = vals[1];
                    break;
                }
                case 1: {
                    midX = (lastX + vals[0]) / 2.0f;
                    midY = (lastY + vals[1]) / 2.0f;
                    s.moveTo(0.0f - midX, 0.0f - midY);
                    s.lineTo(lastX - midX, lastY - midY);
                    s.lineTo(vals[0] - midX, vals[1] - midY);
                    s.closePath();
                    vec = new Double2D(midX, midY).normalize().multiply(force);
                    shard = new Shard(asteroids, s, this.orientation, new MutableDouble2D(vec), new Double2D(location.x + (double)midX, location.y + (double)midY), this.getColor());
                    lastX = vals[0];
                    lastY = vals[1];
                    break;
                }
                case 4: {
                    midX = (lastX + vals[0]) / 2.0f;
                    midY = (lastY + vals[1]) / 2.0f;
                    s.moveTo(0.0f - midX, 0.0f - midY);
                    s.lineTo(lastX - midX, lastY - midY);
                    s.lineTo(firstX - midX, firstY - midY);
                    s.closePath();
                    vec = new Double2D(midX, midY).normalize().multiply(force);
                    shard = new Shard(asteroids, s, this.orientation, new MutableDouble2D(vec), new Double2D(location.x + (double)midX, location.y + (double)midY), this.getColor());
                    lastX = vals[0];
                    lastY = vals[1];
                    break;
                }
                case 2: {
                    midX = (lastX + vals[0] + vals[2]) / 3.0f;
                    midY = (lastY + vals[1] + vals[3]) / 3.0f;
                    s.moveTo(0.0f - midX, 0.0f - midY);
                    s.lineTo(lastX - midX, lastY - midY);
                    s.quadTo(vals[0] - midX, vals[1] - midY, vals[2] - midX, vals[3] - midY);
                    s.closePath();
                    vec = new Double2D(midX, midY).normalize().multiply(force);
                    shard = new Shard(asteroids, s, this.orientation, new MutableDouble2D(vec), new Double2D(location.x + (double)midX, location.y + (double)midY), this.getColor());
                    lastX = vals[2];
                    lastY = vals[3];
                    break;
                }
                case 3: {
                    midX = (lastX + vals[0] + vals[2] + vals[4]) / 4.0f;
                    midY = (lastY + vals[1] + vals[3] + vals[5]) / 4.0f;
                    s.moveTo(0.0f - midX, 0.0f - midY);
                    s.lineTo(lastX - midX, lastY - midY);
                    s.curveTo(vals[0] - midX, vals[1] - midY, vals[2] - midX, vals[3] - midY, vals[4] - midX, vals[5] - midY);
                    s.closePath();
                    vec = new Double2D(midX, midY).normalize().multiply(force);
                    shard = new Shard(asteroids, s, this.orientation, new MutableDouble2D(vec), new Double2D(location.x + (double)midX, location.y + (double)midY), this.getColor());
                    lastX = vals[4];
                    lastY = vals[5];
                }
            }
            p.next();
        }
    }

    public void end(Asteroids asteroids) {
        if (this.stopper != null) {
            this.stopper.stop();
        }
        asteroids.field.remove(this);
    }
}

