/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.AsteroidsWithUI;
import sim.display.SimpleController;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;

public class Overlay
extends FieldPortrayal2D {
    AsteroidsWithUI ui;
    public static final int GUTTER = 48;
    public static final int BORDER = 8;
    public static final int FONTSIZE = 20;
    Font font = new Font("SansSerif", 1, 20);
    Color color = new Color(255, 255, 255, 64);
    int firstTimeScoreY = 0;

    public Overlay(AsteroidsWithUI ui) {
        this.ui = ui;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        Asteroids asteroids = (Asteroids)this.ui.state;
        graphics.setFont(this.font);
        Rectangle2D bounds = new TextLayout("" + asteroids.score, this.font, graphics.getFontRenderContext()).getBounds();
        if (this.firstTimeScoreY == 0) {
            this.firstTimeScoreY = (int)((48.0 + bounds.getHeight()) / 2.0);
        }
        if (((SimpleController)this.ui.controller).getPlayState() == 2) {
            bounds = new TextLayout("Paused", this.font, graphics.getFontRenderContext()).getBounds();
            graphics.setColor(Color.white);
            graphics.drawString("Paused", (int)((info.clip.width - bounds.getWidth()) / 2.0), (int)((info.clip.height - bounds.getHeight()) / 2.0));
        }
        graphics.setColor(this.color);
        String text = "Deaths: " + asteroids.deaths;
        this.drawOutline(graphics, text, 8.0, this.firstTimeScoreY);
        text = "Level: " + asteroids.level;
        this.drawOutline(graphics, text, 8.0, (double)this.firstTimeScoreY + 30.0);
        text = "Score: " + asteroids.score;
        this.drawOutline(graphics, text, 8.0, this.firstTimeScoreY + 60);
        text = "M: MASON";
        this.drawOutline(graphics, text, 8.0, info.clip.height - 48.0 + (double)this.firstTimeScoreY - 90.0);
        text = "P: Pause";
        this.drawOutline(graphics, text, 8.0, info.clip.height - 48.0 + (double)this.firstTimeScoreY - 60.0);
        text = "R: Reset";
        this.drawOutline(graphics, text, 8.0, info.clip.height - 48.0 + (double)this.firstTimeScoreY - 30.0);
        text = "\u2190\u2192\u2191\u2193 space";
        this.drawOutline(graphics, text, 8.0, info.clip.height - 48.0 + (double)this.firstTimeScoreY);
    }

    public void drawOutline(Graphics2D graphics, String text, double x, double y) {
        TextLayout textlo = new TextLayout(text, this.font, graphics.getFontRenderContext());
        Shape outline = textlo.getOutline(null);
        AffineTransform transform = graphics.getTransform();
        AffineTransform oldTransform = graphics.getTransform();
        transform.translate(x, y);
        graphics.transform(transform);
        graphics.draw(outline);
        graphics.setTransform(oldTransform);
    }
}

