/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import sim.engine.SimState;
import sim.engine.Steppable;

public class RateAdjuster
implements Steppable {
    long initialTime;
    long totalTics;
    boolean started = false;
    double rate;

    public RateAdjuster(double targetRate) {
        this.rate = targetRate;
    }

    public void step(SimState state) {
        if (!this.started) {
            this.initialTime = System.currentTimeMillis();
            this.started = true;
        } else {
            long currentTime = System.currentTimeMillis();
            long time = currentTime - this.initialTime;
            ++this.totalTics;
            long expectedTime = (long)((double)this.totalTics / this.rate * 1000.0);
            if (time < expectedTime) {
                try {
                    Thread.currentThread();
                    Thread.sleep(expectedTime - time);
                }
                catch (InterruptedException e) {}
            } else {
                this.initialTime = currentTime;
                this.totalTics = 0L;
            }
        }
    }
}

