/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import java.awt.Color;
import java.awt.Shape;
import sim.app.asteroids.Asteroids;
import sim.app.asteroids.Element;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Shard
extends Element {
    int count;
    Color color;
    public static final double VELOCITY = 1.0;
    public static final int LIFETIME = 100;
    public static final double MAXIMUM_EXPLOSION_FORCE = 0.5;
    public static final double MAXIMUM_ROTATIONAL_VELOCITY = 0.08726646259971647;

    public Shard(Asteroids asteroids, Shape shape, double orientation, MutableDouble2D velocity, Double2D location, Color color) {
        this.velocity = velocity;
        this.shape = shape;
        this.color = color;
        this.count = 100;
        this.stopper = asteroids.schedule.scheduleRepeating(this);
        this.rotationalVelocity = asteroids.random.nextDouble() * 0.08726646259971647 * (asteroids.random.nextBoolean() ? 1.0 : -1.0);
        this.orientation = orientation;
        asteroids.field.setObjectLocation((Object)this, location);
        asteroids.schedule.scheduleOnceIn(100.0, new Steppable(){

            public void step(SimState state) {
                Shard.this.end((Asteroids)state);
            }
        });
    }

    public void step(SimState state) {
        super.step(state);
        --this.count;
    }

    public Color getColor() {
        double v = (double)this.count / 100.0;
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)(255.0 * v));
    }
}

