/*
 * Decompiled with CFR 0.152.
 */
package sim.app.balls3d;

import java.text.NumberFormat;
import javax.swing.JFrame;
import sim.app.balls3d.BallPortrayal;
import sim.app.balls3d.Balls3D;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.field.network.Edge;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.network.CylinderEdgePortrayal3D;
import sim.portrayal3d.network.NetworkPortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.portrayal3d.simple.CircledPortrayal3D;

public class Balls3DWithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    NetworkPortrayal3D edgePortrayal = new NetworkPortrayal3D();
    ContinuousPortrayal3D nodePortrayal = new ContinuousPortrayal3D();

    public static void main(String[] args) {
        new Balls3DWithUI().createController();
    }

    public Balls3DWithUI() {
        super(new Balls3D(System.currentTimeMillis()));
    }

    public Balls3DWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "3D Balls and Bands";
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Balls3D tut = (Balls3D)this.state;
        final NumberFormat strengthFormat = NumberFormat.getInstance();
        strengthFormat.setMinimumIntegerDigits(1);
        strengthFormat.setMaximumFractionDigits(2);
        this.edgePortrayal.setField(new SpatialNetwork3D(tut.balls, tut.bands));
        CylinderEdgePortrayal3D portrayal = new CylinderEdgePortrayal3D(){

            public String getLabel(Edge e) {
                return strengthFormat.format(e.getWeight());
            }
        };
        portrayal.setLabelScale(1.0);
        this.edgePortrayal.setPortrayalForAll(portrayal);
        this.nodePortrayal.setField(tut.balls);
        try {
            this.nodePortrayal.setPortrayalForAll(new CircledPortrayal3D(new BallPortrayal(5.0), 20.0, true));
        }
        catch (Exception e) {
            throw new RuntimeException("yo", e);
        }
        this.display.createSceneGraph();
        this.display.reset();
    }

    public void init(Controller c) {
        super.init(c);
        Balls3D tut = (Balls3D)this.state;
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.edgePortrayal, "Bands");
        this.display.attach(this.nodePortrayal, "Balls");
        this.display.translate(-tut.gridWidth / 2.0, -tut.gridHeight / 2.0, -tut.gridLength / 2.0);
        this.display.scale(1.0 / tut.gridWidth);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Balls and Bands");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.getSelectionBehavior().setTolerance(10.0);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

