/*
 * Decompiled with CFR 0.152.
 */
package sim.app.celegans;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import sim.app.celegans.Cell;
import sim.app.celegans.Synapse;

public class Cells {
    public HashMap cell_dictionary = new HashMap(300);
    public ArrayList roots = new ArrayList();
    int num_processed_cells = 0;
    public Cell P0;

    public Cells() {
        try {
            InputStreamReader r = new InputStreamReader(new GZIPInputStream(Cells.class.getResourceAsStream("cells.ace4.gz")));
            this.readCells(r);
            ((Reader)r).close();
            this.postProcess();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcess() {
        Cell cell;
        System.out.println("-----Assigning Cell Types, and Parents to equivalent-origin cells");
        Iterator<Object> cells = this.cell_dictionary.values().iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            if (cell.official_name.equals("P0")) {
                this.P0 = cell;
            }
            if (cell.parent == null && !cell.official_name.equals("P0") && cell.num_equivalence_origin == 0) {
                System.out.println("Whoa!  This ain't right: " + cell.official_name + "Has no parent.");
            }
            if (cell.parent == null && cell.num_equivalence_origin == 0) {
                this.roots.add(cell);
            }
            if (cell.num_equivalence_origin != 0) {
                cell.type = Cell.cell_type_postembryonic_dual_origin;
                cell.parent = cell.equivalence_origin[0];
                if (cell.parent.equivalence_fate[0] != cell) {
                    cell.parent.equivalence_fate[0].parent = cell.equivalence_origin[1];
                    continue;
                }
                cell.parent.equivalence_fate[1].parent = cell.equivalence_origin[1];
                continue;
            }
            if (cell.official_name.equals("P0") || cell.official_name.equals("P1'") || cell.official_name.equals("P2'") || cell.official_name.equals("AB") || cell.official_name.equals("P3'") || cell.official_name.equals("P4'")) {
                cell.type = Cell.cell_type_preembryonic_unknown_position;
                continue;
            }
            if (cell.official_name.equals("Z3") || cell.official_name.equals("Z2")) {
                cell.type = Cell.cell_type_postembryonic_unknown_position;
                continue;
            }
            if (cell.birthday < Cell.post_embryonic_birthday) {
                cell.type = Cell.cell_type_postembryonic;
                continue;
            }
            cell.type = Cell.cell_type_preembryonic;
        }
        System.out.println("-----Assigning Birthdays and Deaths");
        cells = this.roots.iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            cell.postProcessBirthday(true);
        }
        cells = this.roots.iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            cell.postProcessDeathDay(true);
        }
        System.out.println("-----Assigning Locations");
        cells = this.roots.iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            cell.postProcessLocation(true);
        }
        cells = this.roots.iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            cell.modifyLocations(-30.0, -20.0, -20.0);
        }
        cells = this.roots.iterator();
        while (cells.hasNext()) {
            cell = (Cell)cells.next();
            cell.setVolume(1.0f);
        }
        System.out.println("-----Finished PostProcessing");
    }

    public void readCells(Reader r) {
        Cell currentCell = null;
        ArrayList v = new ArrayList();
        this.num_processed_cells = 0;
        Scanner d = new Scanner(r);
        System.out.println("-----Loading 2237 Cells....");
        System.out.println();
        try {
            while (this.readCellLine(d, v) != -1) {
                currentCell = this.processCellLine(currentCell, v);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        System.out.println();
        System.out.println("-----Phew! Finally finished loading...");
    }

    int readCellLine(Scanner i, ArrayList v) throws IOException {
        int newpos;
        v.clear();
        if (!i.hasNextLine()) {
            return -1;
        }
        String s = i.nextLine();
        int pos = 0;
        int size = s.length();
        while ((newpos = s.indexOf(124, pos)) >= 0 && newpos < size) {
            if (newpos == pos) {
                v.add("");
            } else {
                v.add(s.substring(pos, newpos));
            }
            pos = newpos + 1;
        }
        if (pos != size) {
            v.add(s.substring(pos, size));
        }
        return 1;
    }

    public Cell processCellLine(Cell current, ArrayList v) throws NumberFormatException {
        if (v == null) {
            return current;
        }
        if (v.size() == 0) {
            return current;
        }
        String title = (String)v.get(0);
        if (title.equals("Cell")) {
            current = this.fetchCell((String)v.get(2));
            if (this.num_processed_cells % 100 == 0) {
                System.out.println(this.num_processed_cells + 1 + ": " + current.official_name);
            }
            ++this.num_processed_cells;
        } else {
            if (current == null) {
                return current;
            }
            if (title.equals("Parent")) {
                current.parent = this.fetchCell((String)v.get(1));
                if (current.parent.num_children >= 2) {
                    Cell[] tmp = new Cell[current.parent.num_children + 1];
                    System.arraycopy(current.parent.daughters, 0, tmp, 0, current.parent.num_children);
                    current.parent.daughters = tmp;
                    System.out.print(current.parent.official_name + " has more than 2 children: ");
                    for (int zz = 0; zz < current.parent.num_children; ++zz) {
                        System.out.print(current.parent.daughters[zz].official_name + ", ");
                    }
                    System.out.println("and " + current.official_name);
                }
                current.parent.daughters[current.parent.num_children++] = current;
            } else if (!title.equals("Daughter")) {
                if (title.equals("Lineage_name")) {
                    current.lineage_name = (String)v.get(1);
                } else if (title.equals("Embryo_division_time")) {
                    current.embryo_division_time = Double.valueOf((String)v.get(1));
                } else if (title.equals("Reconstruction")) {
                    if (v.get(2).equals("Birth")) {
                        current.time_born = Double.valueOf((String)v.get(3));
                    } else if (v.get(2).equals("Timepoint")) {
                        current.pushLocation(Double.valueOf((String)v.get(5)), Double.valueOf((String)v.get(6)), Double.valueOf((String)v.get(7)), Double.valueOf((String)v.get(3)));
                    }
                } else if (title.equals("Neurodata")) {
                    if (v.get(3).equals("N2U")) {
                        if (v.get(2).equals("Send") || v.get(2).equals("Send_joint")) {
                            Cell to;
                            Synapse s = new Synapse();
                            s.to = to = this.fetchCell((String)v.get(1));
                            s.from = current;
                            s.type = Synapse.type_chemical;
                            s.number = Integer.valueOf((String)v.get(4));
                            current.synapses.add(s);
                            to.synapses.add(s);
                        } else if (v.get(2).equals("Gap_junction")) {
                            Cell to;
                            Synapse s = new Synapse();
                            s.to = to = this.fetchCell((String)v.get(1));
                            s.from = current;
                            s.type = Synapse.type_gap;
                            s.number = Integer.valueOf((String)v.get(4));
                            current.synapses.add(s);
                            to.synapses.add(s);
                        }
                    }
                } else if (title.equals("Equivalence_origin")) {
                    Cell equiv = this.fetchCell((String)v.get(1));
                    current.equivalence_origin[current.num_equivalence_origin++] = equiv;
                    equiv.equivalence_fate[equiv.num_equivalence_fate++] = current;
                } else if (!title.equals("Equivalence_fate")) {
                    if (title.equals("Cell_group")) {
                        current.cellGroup = this.fetchGroup((String)v.get(1));
                    } else if (title.equals("Expr_pattern")) {
                        current.expressionPattern = this.fetchPattern((String)v.get(1));
                    } else if (title.equals("Fate")) {
                        current.fate = this.fetchFate((String)v.get(1));
                    } else if (title.equals("Remark")) {
                        current.remark = current.remark.equals("") ? (String)v.get(1) : current.remark + "; " + (String)v.get(1);
                    }
                }
            }
        }
        return current;
    }

    public Cell fetchCell(String key) {
        if (this.cell_dictionary.containsKey(key)) {
            return (Cell)this.cell_dictionary.get(key);
        }
        Cell c = new Cell();
        c.official_name = key;
        this.cell_dictionary.put(key, c);
        return c;
    }

    public int fetchGroup(String key) {
        for (int i = 0; i < Cell.cellGroups.length; ++i) {
            if (!Cell.cellGroups[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        System.out.println("Unknown cell group: " + key);
        return 0;
    }

    public int fetchPattern(String key) {
        for (int i = 0; i < Cell.expressionPatterns.length; ++i) {
            if (!Cell.expressionPatterns[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        System.out.println("Unknown expression pattern: " + key);
        return 0;
    }

    public int fetchFate(String key) {
        for (int i = 0; i < Cell.fates.length; ++i) {
            if (!Cell.fates[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        System.out.println("Unknown fate: " + key);
        return 0;
    }
}

