/*
 * Decompiled with CFR 0.152.
 */
package sim.app.crowd3d;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.swing.JFrame;
import javax.vecmath.Color3f;
import sim.app.crowd3d.CrowdSim;
import sim.app.crowd3d.GullCG;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.simple.LightPortrayal3D;
import sim.portrayal3d.simple.Shape3DPortrayal3D;
import sim.portrayal3d.simple.WireFrameBoxPortrayal3D;
import sim.util.Double3D;

public class Crowd3DWithUI
extends GUIState {
    public JFrame displayFrame;
    FieldPortrayal3D boidsP = new ContinuousPortrayal3D();
    Portrayal3D wireFrameP;
    public Display3D display;

    public static void main(String[] args) {
        new Crowd3DWithUI().createController();
    }

    public Crowd3DWithUI() {
        this(new CrowdSim(System.currentTimeMillis()));
    }

    public Crowd3DWithUI(CrowdSim b) {
        super(b);
        this.wireFrameP = new WireFrameBoxPortrayal3D(0.0, 0.0, 0.0, b.spaceWidth, b.spaceHeight, b.spaceDepth);
    }

    public static String getName() {
        return "Crowd Spacing";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.boidsP.setField(((CrowdSim)this.state).boidSpace);
        this.display.reset();
        this.display.createSceneGraph();
    }

    public void init(Controller c) {
        CrowdSim cState = (CrowdSim)this.state;
        super.init(c);
        this.display = new Display3D(500.0, 500.0, this);
        this.display.attach(this.wireFrameP, "Fish tank");
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(new Color3f(new Color(0, 0, 255)), 3));
        Material m = new Material();
        m.setDiffuseColor(new Color3f(new Color(255, 255, 0)));
        m.setSpecularColor(0.5f, 0.5f, 0.5f);
        m.setShininess(64.0f);
        appearance.setMaterial(m);
        this.boidsP.setPortrayalForAll(new Shape3DPortrayal3D((Geometry)new GullCG(), appearance));
        this.display.attach(this.boidsP, "boids");
        this.display.attach(new LightPortrayal3D(new Color(127, 127, 255), new Double3D(-1.0, -1.0, 1.0)), "Light One");
        this.display.attach(new LightPortrayal3D(new Color(127, 255, 127), new Double3D(1.0, -1.0, -1.0)), "Light Two");
        this.display.attach(new LightPortrayal3D(new Color(255, 127, 127), new Double3D(1.0, 1.0, -1.0)), "Light Three");
        this.display.setShowsSpotlight(false);
        this.display.translate(-0.5 * cState.spaceWidth, -0.5 * cState.spaceHeight, -0.5 * cState.spaceDepth);
        this.display.scale(1.0 / Math.max(cState.spaceWidth, Math.max(cState.spaceHeight, cState.spaceDepth)));
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

